/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleContraintsException;
import es.uvigo.ei.aibench.core.operation.execution.Tee;
import es.uvigo.ei.aibench.core.operation.execution.Unifier;
import es.uvigo.ei.pipespecification.storage.CompositedPipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class TeeDefinition
extends PipeDefinition {
    private final PipeDefinition[] branches;
    private int length = -1;
    private Map<String, Class<?>> argumentsSpecification = null;
    private int totalLength = -1;

    TeeDefinition(PipeDefinition ... branches) {
        super(branches[0].getIncomeTypes(), branches[0].getOutcomeTypes());
        for (PipeDefinition definition : branches) {
            if (definition != null) continue;
            throw new IllegalArgumentException("All definitions must be not null");
        }
        if (!Unifier.unifies(Arrays.asList(branches))) {
            throw new IllegalArgumentException("the branches" + TeeDefinition.format(branches) + "don't unify");
        }
        this.branches = branches;
    }

    private static String format(PipeDefinition[] branches) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < branches.length; ++i) {
            stringBuilder.append(branches[i].getIncomeTypes());
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    protected Executable instantiate_(Map<String, Object> args) {
        Executable[] pipes = new Executable[this.branches.length];
        for (int i = 0; i < pipes.length; ++i) {
            pipes[i] = this.branches[i].instantiate(args);
        }
        return new Tee(pipes);
    }

    @Override
    public PipeDefinition join(PipeDefinition rightPart) throws IncompatibleContraintsException {
        return new CompositedPipeDefinition(this, rightPart);
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = 0;
            for (int i = 0; i < this.branches.length; ++i) {
                this.length += this.branches[i].length();
            }
        }
        return this.length;
    }

    @Override
    public Map<String, Class<?>> getArgumentsSpecification() {
        if (this.argumentsSpecification == null) {
            this.argumentsSpecification = new HashMap();
            for (int i = 0; i < this.branches.length; ++i) {
                Map<String, Class<?>> argsSpec = this.branches[i].getArgumentsSpecification();
                this.addAll(this.argumentsSpecification, argsSpec);
            }
        }
        return this.argumentsSpecification;
    }

    private void addAll(Map<String, Class<?>> accumulator, Map<String, Class<?>> argsSpec) {
        for (String key : argsSpec.keySet()) {
            if (accumulator.containsKey(key) && !accumulator.get(key).equals(argsSpec.get(key))) {
                throw new RuntimeException("Incompatible classes for the argument of the same name " + key);
            }
            accumulator.put(key, argsSpec.get(key));
        }
    }

    @Override
    public int totalLength() {
        if (this.totalLength == -1) {
            this.totalLength = 0;
            for (int i = 0; i < this.branches.length; ++i) {
                this.totalLength += this.branches[i].totalLength();
            }
        }
        return this.totalLength;
    }
}

