/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.IncompatibleContraintsException;
import es.uvigo.ei.pipespecification.storage.InvalidAnnotationsFormatException;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinitionLoader;
import es.uvigo.ei.pipespecification.storage.StandardPipeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SimplePipeDefinitionLoader
extends PipeDefinitionLoader {
    private final XPath xPath;

    public SimplePipeDefinitionLoader() {
        try {
            this.xPath = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom").newXPath();
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    String getElementName() {
        return "pipe";
    }

    @Override
    PipeDefinition loadFromElement(final Element element, File file, Map<String, Class<?>> argumentsSpecificationContext) throws IncompatibleContraintsException, InvalidAnnotationsFormatException, ClassNotFoundException {
        assert (element.getLocalName().equals("pipe"));
        NodeList args = element.getElementsByTagNameNS("*", "arg");
        ArrayList<String> argsNames = new ArrayList<String>();
        ArrayList argsTypes = new ArrayList();
        SimplePipeDefinitionLoader.process(args, argumentsSpecificationContext, argsNames, argsTypes);
        String classAttribute = element.getAttribute("class");
        if (classAttribute == null || classAttribute.equals("")) {
            throw new RuntimeException("The element " + element + " must have the atribute class");
        }
        Class<?> klass = Class.forName(classAttribute);
        try {
            this.xPath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return element.getNamespaceURI();
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public Iterator<?> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            NodeList nodes = (NodeList)this.xPath.evaluate("prefix:port", element, XPathConstants.NODESET);
            List<Element> explicitDefinedPorts = PipeDefinitionLoader.getElements(nodes);
            ExecutorService executor = Executors.newFixedThreadPool(3);
            return explicitDefinedPorts.isEmpty() ? new StandardPipeDefinition(klass, argsNames.toArray(new String[0]), argsTypes.toArray(new Class[0]), executor) : new StandardPipeDefinition(klass, explicitDefinedPorts, argsNames.toArray(new String[0]), argsTypes.toArray(new Class[0]), executor);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static void process(NodeList args, Map<String, Class<?>> argumentsSpecificationContext, List<String> argsNames, List<Class<?>> classes) {
        for (int i = 0; i < args.getLength(); ++i) {
            Element argElement = (Element)args.item(i);
            String argument = argElement.getAttribute("name");
            if (argument.equals("")) {
                throw new RuntimeException("The arg attribute inside a pipe element must have a name attribute");
            }
            if (!argumentsSpecificationContext.containsKey(argument)) {
                throw new RuntimeException("The name attribute must point to an already defined attribute");
            }
            argsNames.add(argument);
            classes.add(argumentsSpecificationContext.get(argument));
        }
    }
}

