/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.IncompatibleContraintsException;
import es.uvigo.ei.pipespecification.storage.InvalidAnnotationsFormatException;
import es.uvigo.ei.pipespecification.storage.InvalidSyntaxPipeSpecificationException;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinitionLoader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PipeLoader {
    private static final DocumentBuilder docBuilder;
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    private static NodeList getSpecificationArgs(Document doc) {
        Element args = (Element)doc.getElementsByTagNameNS("*", "args").item(0);
        return args.getElementsByTagNameNS("*", "arg");
    }

    public static PipeDefinition load(File xmlFile) throws SAXException, IOException, ClassNotFoundException, IncompatibleContraintsException, InvalidAnnotationsFormatException {
        Document doc = docBuilder.parse(xmlFile);
        NodeList argsList = PipeLoader.getSpecificationArgs(doc);
        HashMap argsMap = new HashMap();
        for (int i = 0; i < argsList.getLength(); ++i) {
            Element arg = (Element)argsList.item(i);
            String argName = arg.getAttribute("name");
            if (argName.equals("")) continue;
            argsMap.put(argName, Class.forName(arg.getAttribute("class")));
        }
        return PipeDefinitionLoader.load(doc.getDocumentElement(), xmlFile, argsMap);
    }

    static {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            URL resource = PipeLoader.class.getResource("pipes.xsd");
            File xsdFile = new File(resource.toURI());
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(true);
            docBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            docBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, xsdFile);
            docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw new InvalidSyntaxPipeSpecificationException(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw new InvalidSyntaxPipeSpecificationException(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw new InvalidSyntaxPipeSpecificationException(exception);
                }
            });
            assert (docBuilder.isNamespaceAware());
            assert (docBuilder.isValidating());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

