/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleContraintsException;
import es.uvigo.ei.aibench.core.operation.execution.Parallelizer;
import es.uvigo.ei.pipespecification.storage.CompositedPipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParallelizerPipeDefinition
extends PipeDefinition {
    private final List<PipeDefinition> sons;
    private final Map<String, Class<?>> argumentsSpecification;
    private final int length;
    private final int totalLength;

    ParallelizerPipeDefinition(PipeDefinition ... sons) {
        super(ParallelizerPipeDefinition.aggregateIncoming(sons), ParallelizerPipeDefinition.aggregateOutcoming(sons));
        this.sons = new ArrayList<PipeDefinition>(Arrays.asList(sons));
        this.argumentsSpecification = ParallelizerPipeDefinition.aggregateArgumentsSpecification(sons);
        this.length = ParallelizerPipeDefinition.getLength(sons);
        this.totalLength = ParallelizerPipeDefinition.getTotalLength(sons);
    }

    private static int getLength(PipeDefinition[] sons) {
        int acc = 0;
        for (int i = 0; i < sons.length; ++i) {
            acc += sons[i].length();
        }
        return acc;
    }

    private static int getTotalLength(PipeDefinition[] sons) {
        int acc = 0;
        for (int i = 0; i < sons.length; ++i) {
            acc += sons[i].totalLength();
        }
        return acc;
    }

    private static List<Class<?>> aggregateIncoming(PipeDefinition[] pipeDefinitions) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < pipeDefinitions.length; ++i) {
            result.addAll(pipeDefinitions[i].getIncomeTypes());
        }
        return result;
    }

    private static List<Class<?>> aggregateOutcoming(PipeDefinition[] pipeDefinitions) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < pipeDefinitions.length; ++i) {
            result.addAll(pipeDefinitions[i].getOutcomeTypes());
        }
        return result;
    }

    private static Map<String, Class<?>> aggregateArgumentsSpecification(PipeDefinition[] definitions) {
        ArrayList<PipeDefinition> temp = new ArrayList<PipeDefinition>(Arrays.asList(definitions));
        Map<String, Class<?>> args = ((PipeDefinition)temp.remove(0)).getArgumentsSpecification();
        while (temp.size() > 0) {
            args = CompositedPipeDefinition.aggregateArgumentsSpecification(args, (PipeDefinition)temp.remove(0));
        }
        return args;
    }

    @Override
    public PipeDefinition join(PipeDefinition rightPart) throws IncompatibleContraintsException {
        return new CompositedPipeDefinition(this, rightPart);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int totalLength() {
        return this.totalLength;
    }

    @Override
    protected Executable instantiate_(Map<String, Object> args) {
        Executable[] executables = new Executable[this.sons.size()];
        return new Parallelizer(executables);
    }

    @Override
    public Map<String, Class<?>> getArgumentsSpecification() {
        return this.argumentsSpecification;
    }
}

