/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;

class TypesChecker
implements ResultsCollector {
    private final Class<?>[] classes;
    private final ResultsCollector decorated;
    private final boolean[] called;

    public TypesChecker(Class<?>[] classes, ResultsCollector collector) {
        if (collector == null) {
            throw new NullPointerException("collector can't be null");
        }
        this.classes = (Class[])classes.clone();
        this.decorated = collector;
        this.called = new boolean[classes.length];
    }

    @Override
    public void finish() {
        for (int i = 0; i < this.called.length; ++i) {
            if (this.called[i]) continue;
            throw new IllegalStateException("the endpoint " + i + " has not been called");
        }
        this.decorated.finish();
    }

    @Override
    public void newResult(int index, Object result) throws IndexOutOfBoundsException, ClassCastException {
        if (result != Void.TYPE) {
            this.classes[index].cast(result);
        } else if (!this.classes[index].equals(result)) {
            throw new ClassCastException("not expected Void.TYPE");
        }
        this.called[index] = true;
        this.decorated.newResult(index, result);
    }

    @Override
    public void crash(Throwable cause) {
        this.decorated.crash(cause);
    }
}

