/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPointForwarder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class TeeExecutionSession
implements ExecutionSession {
    private final List<IncomingEndPoint> incomingEndPoints;
    private final List<ExecutionSession> branches;

    public TeeExecutionSession(List<ExecutionSession> branches) {
        if (branches.size() == 0) {
            throw new IllegalArgumentException("the number of branches must be at least one");
        }
        this.branches = new ArrayList<ExecutionSession>(branches);
        ArrayList<List<? extends IncomingEndPoint>> allIncoming = new ArrayList<List<? extends IncomingEndPoint>>();
        for (ExecutionSession branch : branches) {
            allIncoming.add(branch.getIncomingEndpoints());
        }
        int size = ((List)allIncoming.get(0)).size();
        ArrayList<IncomingEndPointForwarder> incoming = new ArrayList<IncomingEndPointForwarder>();
        for (int i = 0; i < size; ++i) {
            IncomingEndPoint[] endPoints = TeeExecutionSession.extract(allIncoming, i);
            incoming.add(new IncomingEndPointForwarder(endPoints));
        }
        assert (incoming.size() == size);
        this.incomingEndPoints = Collections.unmodifiableList(incoming);
    }

    private static IncomingEndPoint[] extract(List<List<? extends IncomingEndPoint>> branchesIncoming, int index) {
        IncomingEndPoint[] result = new IncomingEndPoint[branchesIncoming.size()];
        int i = 0;
        for (List<? extends IncomingEndPoint> list : branchesIncoming) {
            result[i++] = list.get(index);
        }
        assert (i == branchesIncoming.size());
        return result;
    }

    @Override
    public List<? extends IncomingEndPoint> getIncomingEndpoints() {
        return this.incomingEndPoints;
    }

    @Override
    public void finish() {
        for (ExecutionSession branch : this.branches) {
            branch.finish();
        }
    }

    @Override
    public void cancel() {
    }
}

