/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.AbstractExecutable;
import es.uvigo.ei.aibench.core.operation.execution.CompositedCollector;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.OffsetCollector;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import es.uvigo.ei.aibench.core.operation.execution.TeeExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.Unifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Tee
extends AbstractExecutable {
    private final List<Executable> branches;
    private final List<Class<?>> incomeArgumentTypes;
    private final List<Class<?>> outcomeArgumentsTypes;

    public Tee(Executable ... branches) {
        if (branches.length == 0) {
            throw new IllegalArgumentException("the branches must be at least one");
        }
        Tee.checkElementsNotNull(branches);
        this.branches = Arrays.asList(branches);
        ArrayList outcomeArguments = new ArrayList();
        for (Executable executable : branches) {
            outcomeArguments.addAll(executable.getOutcomeArgumentTypes());
        }
        List<Class<?>> incomeArgumentTypes = Unifier.unifier(Arrays.asList(branches));
        if (incomeArgumentTypes == null) {
            throw new IllegalArgumentException("The branches of the Tee can't be unified. Have incompatible types");
        }
        this.incomeArgumentTypes = Collections.unmodifiableList(incomeArgumentTypes);
        this.outcomeArgumentsTypes = Collections.unmodifiableList(outcomeArguments);
    }

    @Override
    public List<Class<?>> getIncomeArgumentTypes() {
        return this.incomeArgumentTypes;
    }

    @Override
    public List<Class<?>> getOutcomeArgumentTypes() {
        return this.outcomeArgumentsTypes;
    }

    @Override
    public ExecutionSession openExecutionSession(ResultsCollector collector) {
        return new TeeExecutionSession(Tee.extractSessions(this.branches, new CompositedCollector(collector, this.branches.size())));
    }

    private static List<ExecutionSession> extractSessions(List<Executable> branches2, ResultsCollector collector) {
        ArrayList<ExecutionSession> result = new ArrayList<ExecutionSession>();
        int offset = 0;
        for (Executable executable : branches2) {
            result.add(executable.openExecutionSession(new OffsetCollector(offset, collector)));
            offset += executable.getIncomeArgumentTypes().size();
        }
        return result;
    }
}

