/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class SynchronousResultCollector
implements ResultsCollector {
    private boolean finished = false;
    private Throwable exception = null;
    private final List<List<Object>> results = new ArrayList<List<Object>>();
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public synchronized void finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.latch.countDown();
    }

    @Override
    public synchronized void newResult(int index, Object result) {
        if (this.finished) {
            throw new IllegalStateException("Once finished can't receive more results");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must be greater than zero");
        }
        while (index > this.results.size() - 1) {
            this.results.add(new ArrayList());
        }
        this.results.get(index).add(result);
    }

    public List<List<Object>> getResults() throws Throwable {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return SynchronousResultCollector.unmodify(this.results);
    }

    private static List<List<Object>> unmodify(List<List<Object>> results2) {
        ArrayList<List<Object>> unmodifiable = new ArrayList<List<Object>>();
        for (List<Object> list : results2) {
            unmodifiable.add(Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableList(unmodifiable);
    }

    @Override
    public void crash(Throwable cause) {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.exception = cause;
        this.latch.countDown();
    }
}

