/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.AbstractExecutable;
import es.uvigo.ei.aibench.core.operation.execution.EndpointsFactory;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import es.uvigo.ei.aibench.core.operation.execution.StandardExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.TypesChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class StandardExecutable<T>
extends AbstractExecutable {
    private final List<Class<?>> incomeArguments;
    private final List<Class<?>> outcomeArguments;
    private final List<EndpointsFactory<T>> factories;
    private final T executableInstance;
    private final ExecutorService executor;

    public StandardExecutable(List<EndpointsFactory<T>> factories, List<Class<?>> incomeArgumentTypes, List<Class<?>> outcomeArgumentTypes, ExecutorService executor, T executableInstance, Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        if (executableInstance == null) {
            throw new NullPointerException("executable instance can't be null");
        }
        this.executableInstance = executableInstance;
        this.factories = Collections.unmodifiableList(new ArrayList<EndpointsFactory<T>>(factories));
        this.incomeArguments = Collections.unmodifiableList(new ArrayList(incomeArgumentTypes));
        this.outcomeArguments = Collections.unmodifiableList(new ArrayList(outcomeArgumentTypes));
        this.executor = executor;
    }

    @Override
    public ExecutionSession openExecutionSession(ResultsCollector collector) {
        try {
            return new StandardExecutionSession<T>(this.factories, this.executableInstance, new TypesChecker(this.getOutcomeArgumentTypes().toArray(new Class[0]), collector), this.executor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Class<?>> getIncomeArgumentTypes() {
        return this.incomeArguments;
    }

    @Override
    public List<Class<?>> getOutcomeArgumentTypes() {
        return this.outcomeArguments;
    }
}

