/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CompositedExecutionSession
implements ExecutionSession {
    private final List<ExecutionSession> sessions;
    private final List<IncomingEndPoint> incomingEndPoints;
    private boolean finished = false;

    CompositedExecutionSession(ResultsCollector collector, ExecutionSession ... sessions) {
        this(Arrays.asList(sessions));
    }

    CompositedExecutionSession(List<ExecutionSession> sessions) {
        this.sessions = Collections.unmodifiableList(new ArrayList<ExecutionSession>(sessions));
        ArrayList<? extends IncomingEndPoint> list = new ArrayList<IncomingEndPoint>();
        for (ExecutionSession session : sessions) {
            list.addAll(session.getIncomingEndpoints());
        }
        this.incomingEndPoints = Collections.unmodifiableList(list);
    }

    @Override
    public List<? extends IncomingEndPoint> getIncomingEndpoints() {
        return this.incomingEndPoints;
    }

    @Override
    public void finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        for (ExecutionSession session : this.sessions) {
            session.finish();
        }
    }

    @Override
    public void cancel() {
    }
}

