/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;

class CompositedCollector
implements ResultsCollector {
    private final ResultsCollector collector;
    private int times;

    CompositedCollector(ResultsCollector collector, int i) {
        if (collector == null) {
            throw new NullPointerException("collector can't be null");
        }
        if (i < 1) {
            throw new IllegalArgumentException("i must be greater than zero");
        }
        this.collector = collector;
        this.times = i;
    }

    @Override
    public void finish() {
        if (this.times == 0) {
            throw new IllegalStateException("finish not expected");
        }
        if (--this.times == 0) {
            this.collector.finish();
        }
    }

    @Override
    public void newResult(int index, Object result) {
        this.collector.newResult(index, result);
    }

    @Override
    public void crash(Throwable cause) {
        this.collector.crash(cause);
    }
}

