/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.CollectorAdapter;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleContraintsException;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CollectorAdapterFactory {
    private final List<Map.Entry<Class<?>, Integer>> groupsSpecification;
    private final Executable adapted;

    public static CollectorAdapterFactory adapt(Executable one, Executable next) {
        List<Class<?>> oneOutcome = one.getOutcomeArgumentTypes();
        List<Class<?>> nextIncome = next.getIncomeArgumentTypes();
        List<Map.Entry<Class<?>, Integer>> groups = CollectorAdapterFactory.unify(oneOutcome, nextIncome);
        return new CollectorAdapterFactory(next, groups);
    }

    public static List<Map.Entry<Class<?>, Integer>> join(PipeDefinition present, PipeDefinition next) throws IncompatibleContraintsException {
        List<Map.Entry<Class<?>, Integer>> unify = null;
        try {
            unify = CollectorAdapterFactory.unify(present.getOutcomeTypes(), next.getIncomeTypes());
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleContraintsException(e.getMessage());
        }
        return unify;
    }

    private static String format(List<Class<?>> oneOutcome, List<Class<?>> nextIncome) {
        return oneOutcome.toString() + " , " + nextIncome.toString();
    }

    private static List<Map.Entry<Class<?>, Integer>> unify(List<Class<?>> oneOutcome, List<Class<?>> nextIncome) {
        if (oneOutcome.size() < nextIncome.size()) {
            throw new IllegalArgumentException("the executables cannot be unified since the next can't have less incomingEndPoints than the present outcomingEndPoints. " + CollectorAdapterFactory.format(oneOutcome, nextIncome));
        }
        ArrayList result = new ArrayList();
        if (!CollectorAdapterFactory.join(new ArrayList(oneOutcome), new ArrayList(nextIncome), result)) {
            throw new IllegalArgumentException("the executables cannot be unified. " + CollectorAdapterFactory.format(oneOutcome, nextIncome));
        }
        return result;
    }

    private static boolean join(List<Class<?>> left, List<Class<?>> right, List<Map.Entry<Class<?>, Integer>> result) {
        if (left.size() == 0) {
            return right.size() == 0;
        }
        int resultSize = result.size();
        int extra = left.size() - right.size();
        Class<?> first = left.remove(0);
        assert (extra >= 0);
        boolean sucess = false;
        do {
            ArrayList newRight;
            boolean bl = sucess = CollectorAdapterFactory.joinClass(first, newRight = new ArrayList(right), extra, result) && CollectorAdapterFactory.join(left, newRight, result);
            if (sucess) continue;
            int difference = result.size() - resultSize;
            assert (difference >= 0);
            for (int i = result.size() - difference; i < result.size(); ++i) {
                result.remove(i);
            }
            assert (result.size() == resultSize);
        } while (!sucess && --extra >= 0);
        return sucess;
    }

    private static boolean joinClass(Class<?> first, List<Class<?>> right, int extra, List<Map.Entry<Class<?>, Integer>> result) {
        int i;
        int total = extra + 1;
        for (i = 0; i < total; ++i) {
            if (CollectorAdapterFactory.compatible(first, right.get(i))) continue;
            return false;
        }
        for (i = 0; i < total; ++i) {
            right.remove(0);
        }
        result.add(new GroupSpecification(first, total));
        return true;
    }

    private static boolean compatible(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) || right.equals(Void.TYPE);
    }

    private CollectorAdapterFactory(Executable adapted, List<Map.Entry<Class<?>, Integer>> groups) {
        if (adapted == null) {
            throw new NullPointerException("adapted can't be null");
        }
        this.adapted = adapted;
        this.groupsSpecification = groups;
    }

    ResultsCollector getAdapter(ResultsCollector collector) {
        return new CollectorAdapter(this.adapted.openExecutionSession(collector), this.groupsSpecification);
    }

    private static class GroupSpecification
    implements Map.Entry<Class<?>, Integer> {
        private final Class<?> klass;
        private final Integer integer;

        public GroupSpecification(Class<?> klass, Integer integer) {
            this.klass = klass;
            this.integer = integer;
        }

        @Override
        public Class<?> getKey() {
            return this.klass;
        }

        @Override
        public Integer getValue() {
            return this.integer;
        }

        @Override
        public Integer setValue(Integer value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.klass + ":" + this.integer;
        }
    }
}

