/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.history;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.history.HistoryElement;
import es.uvigo.ei.aibench.core.history.HistoryElementImpl;
import es.uvigo.ei.aibench.core.history.HistoryListener;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class History
implements ClipboardListener {
    static Logger logger = Logger.getLogger((String)History.class.getName());
    private ArrayList<HistoryElement> historyElements = new ArrayList();
    private HashMap<ClipboardItem, HistoryElement> clipboardMapping = new HashMap();
    private ArrayList<HistoryListener> listeners = new ArrayList();
    boolean listeningToClipboard = false;

    public void addHistoryListener(HistoryListener listener) {
        this.listeners.add(listener);
    }

    public void putHistoryElement(ParamSpec[] params, OperationDefinition<?> operation, List<ClipboardItem> results, List<Object> portOutputs) {
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("Putting history object, output of operation: " + operation.getName()));
        }
        if (!this.listeningToClipboard) {
            Core.getInstance().getClipboard().addClipboardListener(this);
            this.listeningToClipboard = true;
        }
        HistoryElementImpl historyElement = new HistoryElementImpl(params, operation, results, portOutputs);
        for (ClipboardItem item : results) {
            this.clipboardMapping.put(item, historyElement);
        }
        this.fireElementAdded(historyElement);
        this.historyElements.add(historyElement);
    }

    public List<HistoryElement> getHistory() {
        return this.historyElements;
    }

    public HistoryElement getSourceOfClipboardItem(ClipboardItem item) {
        return this.clipboardMapping.get(item);
    }

    private void fireElementAdded(HistoryElement element) {
        for (HistoryListener listener : this.listeners) {
            listener.historyElementAdded(element);
        }
    }

    @Override
    public void elementAdded(ClipboardItem item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementRemoved(ClipboardItem item) {
        if (this.clipboardMapping.containsKey(item)) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"removed clipboard from history mapping");
            }
            this.clipboardMapping.remove(item);
        }
        Iterator<HistoryElement> iterator = this.getHistory().iterator();
        while (iterator.hasNext()) {
            HistoryElement elem;
            HistoryElement historyElement = elem = iterator.next();
            synchronized (historyElement) {
                int i;
                for (i = elem.getClipboardItems().size() - 1; i >= 0; --i) {
                    if (elem.getClipboardItems().get(i) != item) continue;
                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                        logger.debug((Object)"removed clipboard item from history");
                    }
                    elem.getClipboardItems().remove(i);
                }
                for (i = elem.getOutputs().size() - 1; i >= 0; --i) {
                    if (elem.getOutputs().get(i) != item.getUserData()) continue;
                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                        logger.debug((Object)"removed clipboard item from history output");
                    }
                    elem.getOutputs().remove(i);
                }
                for (i = elem.getParams().length - 1; i >= 0; --i) {
                    if (elem.getParams()[i] == null) continue;
                    if (elem.getParams()[i].getSource() == ParamSource.CLIPBOARD && elem.getParams()[i].getValue() == item && logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                        logger.debug((Object)"removed clipboard item from params in history elem");
                    }
                    --i;
                }
            }
        }
    }

    public void removeItem(HistoryElement element) {
        this.historyElements.remove(element);
        for (ClipboardItem citem : element.getClipboardItems()) {
            Core.getInstance().getClipboard().removeClipboardItem(citem);
        }
        for (HistoryListener listener : this.listeners) {
            listener.historyElementRemoved(element);
        }
    }
}

