/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.datatypes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Transformer {
    private Method method;
    private Object instance;
    private String name;

    public Transformer(Method m) {
        this.method = m;
        if (m == null) {
            throw new NullPointerException("method cant be null");
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            try {
                Class<?> c = m.getDeclaringClass();
                this.instance = c.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public Object transform(Object source) {
        try {
            return this.method.invoke(this.instance, source);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Class<?> getSourceType() {
        Class<?>[] params = this.method.getParameterTypes();
        return params[0];
    }

    public Class<?> getDestinyType() {
        return this.method.getReturnType();
    }

    public String getSignature() {
        return "" + this.getSourceType().getName() + "->" + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "->" + this.getDestinyType().getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

