/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core;

import es.uvigo.ei.aibench.core.Base64Coder;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.PluginsObjectInputStream;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.datatypes.Transformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ParamSpec {
    private Class<?> type;
    private Object value;
    private ParamSource source;
    private String name;
    private String transformerSignature;
    private Object unserializedInstance = null;
    public Object transformedValue;

    public ParamSpec(String name, Class<?> type, ParamSpec[] values) throws IllegalArgumentException {
        if (!type.isArray()) {
            throw new IllegalArgumentException("The type must be array");
        }
        this.type = type;
        this.value = values;
        this.source = ParamSource.MIXED;
        this.name = name;
    }

    public ParamSpec(String name, Class<?> type, Object value, ParamSource source) throws IllegalArgumentException {
        if (type.isArray() && source != ParamSource.CLIPBOARD || source == ParamSource.MIXED) {
            throw new IllegalArgumentException("can't use MIXED source with only one value");
        }
        this.type = type;
        this.value = value;
        this.source = source;
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRawValue() {
        if (this.value == null) {
            return null;
        }
        if (this.source == ParamSource.MIXED) {
            Object arrayResult = Array.newInstance(this.type.getComponentType(), ((ParamSpec[])this.value).length);
            int i = 0;
            for (ParamSpec spec : (ParamSpec[])this.value) {
                Array.set(arrayResult, i++, spec.getRawValue());
            }
            return arrayResult;
        }
        if (this.source == ParamSource.STRING_CONSTRUCTOR) {
            try {
                Class<Object> inClass = this.type;
                if (inClass.equals(Float.TYPE)) {
                    inClass = Float.class;
                } else if (inClass.equals(Integer.TYPE)) {
                    inClass = Integer.class;
                } else if (inClass.equals(Long.TYPE)) {
                    inClass = Long.class;
                } else if (inClass.equals(Double.TYPE)) {
                    inClass = Double.class;
                } else if (inClass.equals(Character.TYPE)) {
                    inClass = Character.class;
                } else if (inClass.equals(Boolean.TYPE)) {
                    inClass = Boolean.class;
                }
                Constructor<Object> c = null;
                Object o = null;
                if (inClass == Character.class) {
                    c = Character.class.getConstructor(Character.TYPE);
                    o = c.newInstance(Character.valueOf(this.value.toString().charAt(0)));
                } else {
                    c = inClass.getConstructor(String.class);
                    o = c.newInstance(this.value.toString());
                }
                if (inClass.equals(Float.TYPE)) {
                    return Float.valueOf(((Float)o).floatValue());
                }
                if (inClass.equals(Integer.TYPE)) {
                    return (int)((Integer)o);
                }
                if (inClass.equals(Long.TYPE)) {
                    return (long)((Long)o);
                }
                if (inClass.equals(Double.TYPE)) {
                    return (double)((Double)o);
                }
                if (inClass.equals(Character.TYPE)) {
                    return Character.valueOf(((Character)o).charValue());
                }
                return o;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.source == ParamSource.CLIPBOARD) {
            if (this.getTransformerSignature() != null) {
                Transformer t = Core.getInstance().getTransformerBySignature(this.getTransformerSignature());
                if (t != null) {
                    if (this.transformedValue == null) {
                        this.transformedValue = t.transform(((ClipboardItem)this.value).getUserData());
                    }
                    return this.transformedValue;
                }
                throw new RuntimeException("Transformer for signature: " + this.getTransformerSignature() + " not available in the Core");
            }
            return ((ClipboardItem)this.value).getUserData();
        }
        if (this.source == ParamSource.SERIALIZED) {
            if (this.unserializedInstance == null) {
                ObjectInputStream ois = null;
                try {
                    ois = new PluginsObjectInputStream(new ByteArrayInputStream(Base64Coder.decode(this.value.toString())));
                    this.unserializedInstance = ois.readObject();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return this.unserializedInstance;
        }
        return this.value;
    }

    public ParamSource getSource() {
        return this.source;
    }

    public String toString() {
        String toret = "---ParamSpec----";
        toret = toret + "\nClass: " + this.type;
        toret = toret + "\nValue: " + this.value;
        toret = toret + "\nSource: " + (Object)((Object)this.source);
        if (this.source == ParamSource.MIXED) {
            toret = toret + "\nSubSpec: " + (Object)((Object)this.source);
            for (ParamSpec sub : (ParamSpec[])this.value) {
                toret = toret + sub.toString();
            }
        }
        toret = toret + "\nTransformer: " + this.transformerSignature;
        toret = toret + "\n---------------";
        toret = this.transformerSignature == null ? (this.getRawValue() != null ? this.getRawValue().toString() : "<null>") : this.getValue().toString() + " (pending transformation)";
        return toret;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getTransformerSignature() {
        return this.transformerSignature;
    }

    public void setTransformerSignature(String transformerSignature) {
        this.transformerSignature = transformerSignature;
    }
}

