/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core;

import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.CoreListener;
import es.uvigo.ei.aibench.core.CoreUtils;
import es.uvigo.ei.aibench.core.IGenericGUI;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.ProgressHandler;
import es.uvigo.ei.aibench.core.clipboard.Clipboard;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.datatypes.Transformer;
import es.uvigo.ei.aibench.core.history.History;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.Operation;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.SynchronousResultCollector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginXmlNode;

public class Core {
    private static final String HELP_HS_PATH = String.format("help%shelpset.hs", File.separator);
    static Logger logger = Logger.getLogger((String)Core.class.getName());
    public static Properties CONFIG = new Properties();
    private static Core _instance = null;
    private List<OperationDefinition<?>> operations = new ArrayList();
    private HashMap<OperationDefinition<?>, Object> operationInstances = new HashMap();
    private HashMap<OperationDefinition<?>, Class<?>> operationAnnotatedClasses = new HashMap();
    private HashSet<OperationDefinition<?>> enabledOperations = new HashSet();
    private HashMap<Class<?>, List<Transformer>> transformersBySource = new HashMap();
    private HashMap<Class<?>, List<Transformer>> transformersByDestiny = new HashMap();
    private HashMap<String, Transformer> transformersBySignature = new HashMap();
    private List<CoreListener> coreListeners = new LinkedList<CoreListener>();
    private IGenericGUI gui = null;
    private Clipboard clipboard = new Clipboard();
    private History history = new History();
    private ExecutorService pool;
    private int runningCount = 0;
    private HelpBroker helpBroker;
    private static HashMap<Integer, Core> _coreInstances = new HashMap();

    private Core() {
        Core.readConfig();
        this.createThreadPool();
        this.createOperations();
        this.createTransformers();
    }

    public static synchronized Core getInstance() {
        if (_instance == null) {
            _instance = new Core();
        }
        return _instance;
    }

    public static synchronized Core getInstance(Integer key) {
        Core i = _coreInstances.get(key);
        if (i == null) {
            i = new Core();
            _coreInstances.put(key, i);
        }
        return i;
    }

    public static synchronized Core removeInstance(Integer key) {
        return _coreInstances.remove(key);
    }

    public void addCoreListener(CoreListener listener) {
        this.coreListeners.add(listener);
    }

    public void removeCoreListener(CoreListener listener) {
        this.coreListeners.remove(listener);
    }

    private void createThreadPool() {
        int poolSize = Runtime.getRuntime().availableProcessors() * 2;
        if (CONFIG.getProperty("threadpool.size") != null) {
            try {
                poolSize = Integer.parseInt(CONFIG.getProperty("threadpool.size"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("configuration parameter: threadpool.size is not an integer, using default value: " + poolSize));
            }
        }
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("Using a pool size of " + poolSize + " threads"));
        }
        this.pool = Executors.newFixedThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread t = new Thread(arg0);
                return t;
            }
        });
    }

    public List<OperationDefinition<?>> getOperations() {
        return this.operations;
    }

    public OperationDefinition<?> getOperationById(String uid) {
        OperationDefinition<?> op = null;
        for (OperationDefinition<?> desc : Core.getInstance().getOperations()) {
            if (!desc.getID().equals(uid)) continue;
            op = desc;
            break;
        }
        return op;
    }

    public OperationDefinition<?> getOperationById(Integer key, String uid) {
        OperationDefinition<?> op = null;
        for (OperationDefinition<?> desc : Core.getInstance(key).getOperations()) {
            if (!desc.getID().equals(uid)) continue;
            op = desc;
            break;
        }
        return op;
    }

    public List<Transformer> getTransformersBySource(Class<?> sourceType) {
        ArrayList<Transformer> result = new ArrayList<Transformer>();
        for (Class<?> source : this.transformersBySource.keySet()) {
            if (!source.isAssignableFrom(sourceType)) continue;
            result.addAll((Collection<Transformer>)this.transformersBySource.get(source));
        }
        return result;
    }

    public List<Transformer> getTransformersByDestiny(Class<?> destinyType) {
        ArrayList<Transformer> result = new ArrayList<Transformer>();
        for (Class<?> destiny : this.transformersByDestiny.keySet()) {
            if (!destinyType.isAssignableFrom(destiny)) continue;
            result.addAll((Collection<Transformer>)this.transformersByDestiny.get(destiny));
        }
        return result;
    }

    public List<Transformer> getAllTransformers() {
        ArrayList<Transformer> list = new ArrayList<Transformer>();
        list.addAll(this.transformersBySignature.values());
        return list;
    }

    public Transformer getTransformerBySignature(String signature) {
        return this.transformersBySignature.get(signature);
    }

    private void createOperations() {
        Plugin plugin = PluginEngine.getPlugin(this.getClass());
        List extensions = plugin.getExtensionPoint("aibench.core.operation-definition").getExtensions();
        for (Extension extension : extensions) {
            Class annotatedClass = extension.getExtensionClass();
            if (annotatedClass.getAnnotation(Operation.class) == null) continue;
            try {
                OperationDefinition operationDefinition = OperationDefinition.createOperationDefinition(annotatedClass);
                operationDefinition.setPluginName(extension.getPlugin().getName());
                operationDefinition.setPluginID(extension.getPlugin().getUID());
                List children = extension.getExtensionXmlNode().getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    PluginXmlNode node = (PluginXmlNode)children.get(i);
                    if (!node.getName().equals("operation-description")) continue;
                    String configName = CONFIG.getProperty(node.getAttribute("uid") + ".name");
                    if (configName != null) {
                        operationDefinition.setName(configName);
                    } else {
                        String name = node.getAttribute("name");
                        if (name != null) {
                            operationDefinition.setName(name);
                        }
                    }
                    operationDefinition.setID(node.getAttribute("uid"));
                    String configPath = CONFIG.getProperty(node.getAttribute("uid") + ".path");
                    if (configPath != null) {
                        operationDefinition.setPath(configPath);
                    } else {
                        String path = node.getAttribute("path");
                        if (path != null) {
                            operationDefinition.setPath(path);
                        }
                    }
                    String helpNode = CONFIG.getProperty(node.getAttribute("uid") + ".help");
                    if (helpNode != null) {
                        operationDefinition.setHelp(helpNode);
                    } else {
                        String help = node.getAttribute("help");
                        if (help != null) {
                            operationDefinition.setHelp(help);
                        }
                    }
                    String shortcut = node.getAttribute("shortcut");
                    if (shortcut == null) continue;
                    operationDefinition.setShortcut(shortcut);
                }
                try {
                    this.operationInstances.put(operationDefinition, annotatedClass.newInstance());
                    this.operationAnnotatedClasses.put(operationDefinition, annotatedClass);
                    this.operations.add(operationDefinition);
                    if (!operationDefinition.isEnabledByDefault()) continue;
                    this.enabledOperations.add(operationDefinition);
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
        }
    }

    private void createTransformers() {
        Plugin plugin = PluginEngine.getPlugin(this.getClass());
        List extensions = plugin.getExtensionPoint("aibench.core.transformer-definition").getExtensions();
        for (Extension extension : extensions) {
            Plugin extensionPlugin = extension.getPlugin();
            try {
                List children = extension.getExtensionXmlNode().getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    PluginXmlNode node = (PluginXmlNode)children.get(i);
                    if (!node.getName().equals("transformer-description")) continue;
                    Class<?> transformerClass = extensionPlugin.getPluginClassLoader().loadClass(node.getAttribute("transformerClass"));
                    Class<?> sourceType = null;
                    Class[] params = null;
                    if (node.getAttribute("sourceType") != null) {
                        sourceType = extensionPlugin.getPluginClassLoader().loadClass(node.getAttribute("sourceType"));
                        params = new Class[]{sourceType};
                    }
                    Method method = transformerClass.getMethod(node.getAttribute("methodName"), params);
                    Class<?> destinyType = extensionPlugin.getPluginClassLoader().loadClass(node.getAttribute("destinyType"));
                    if (!destinyType.isAssignableFrom(method.getReturnType())) {
                        logger.warn((Object)"Cant create transformer");
                    }
                    Transformer transformer = new Transformer(method);
                    if (node.getAttribute("name") != null) {
                        transformer.setName(node.getAttribute("name"));
                    } else {
                        transformer.setName(transformerClass.getName() + "::" + sourceType.getSimpleName() + "->" + destinyType.getSimpleName());
                    }
                    List<Transformer> tlist = this.transformersByDestiny.get(destinyType);
                    if (tlist == null) {
                        tlist = new ArrayList<Transformer>();
                        this.transformersByDestiny.put(destinyType, tlist);
                    }
                    tlist.add(transformer);
                    if (sourceType != null) {
                        List<Transformer> tlist2 = this.transformersBySource.get(sourceType);
                        if (tlist2 == null) {
                            tlist2 = new ArrayList<Transformer>();
                            this.transformersBySource.put(sourceType, tlist2);
                        }
                        tlist2.add(transformer);
                    }
                    this.transformersBySignature.put(transformer.getSignature(), transformer);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Cant create transformed defined in plugin " + extensionPlugin + ": " + e));
            }
        }
    }

    public IGenericGUI getGUI() {
        if (this.gui == null) {
            Plugin plugin = PluginEngine.getPlugin(this.getClass());
            List extensions = plugin.getExtensionPoint("aibench.core.gui").getExtensions();
            if (extensions.size() == 0) {
                this.gui = new IGenericGUI(){

                    @Override
                    public void init() {
                    }

                    @Override
                    public void update() {
                    }

                    @Override
                    public void info(String info) {
                        System.out.println(info);
                    }

                    @Override
                    public void warn(String warning) {
                        System.err.println(warning);
                    }

                    @Override
                    public void error(Throwable error) {
                        System.err.println(error);
                        error.printStackTrace();
                    }

                    @Override
                    public void error(String error) {
                        System.err.println(error);
                    }

                    @Override
                    public void setStatusText(String text) {
                        System.out.println(text);
                    }
                };
            } else {
                Extension _extension = (Extension)extensions.get(0);
                this.gui = (IGenericGUI)_extension.getExtensionInstance();
            }
        }
        return this.gui;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public History getHistory() {
        return this.history;
    }

    public String getHelpPath() {
        String path = "";
        if (this.helpBroker == null && Boolean.parseBoolean(CONFIG.getProperty("help.enabled", "false")) && (path = CONFIG.getProperty("help.path")) == null) {
            path = HELP_HS_PATH;
        }
        return path;
    }

    private synchronized void createHelpBroker() {
        if (this.helpBroker == null && Boolean.parseBoolean(CONFIG.getProperty("help.enabled", "false"))) {
            String path = CONFIG.getProperty("help.path");
            if (path == null) {
                path = HELP_HS_PATH;
            }
            try {
                URL hsURL = new File(path).toURI().toURL();
                this.helpBroker = new DefaultHelpBroker(new HelpSet(null, hsURL));
                logger.info((Object)("HelpSet " + path + " configured"));
            }
            catch (Exception ee) {
                logger.error((Object)("HelpSet " + path + " not found"), (Throwable)ee);
                this.helpBroker = null;
            }
        }
    }

    public HelpBroker getHelpBroker() {
        if (this.helpBroker == null) {
            this.createHelpBroker();
        }
        return this.helpBroker;
    }

    private void validate(OperationDefinition<?> operationDefinition, Object operationObject, ParamSpec[] specs) throws Throwable {
        ArrayList<Port> incomingPorts = new ArrayList<Port>();
        for (Port p : operationDefinition.getPorts()) {
            if (p.direction() == Direction.OUTPUT) continue;
            incomingPorts.add(p);
        }
        int i = 0;
        for (Port p : incomingPorts) {
            if (!p.validateMethod().equals("")) {
                ParamSpec spec = specs[i];
                if (spec.getType().isPrimitive() && spec.getValue().toString().equals("")) {
                    throw new IllegalArgumentException(spec.getName() + ": Primitive params can't be null");
                }
                try {
                    Method validateMethod = operationObject.getClass().getMethod(p.validateMethod(), spec.getType());
                    try {
                        validateMethod.invoke(operationObject, spec.getRawValue());
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public synchronized <T> void executeOperation(final OperationDefinition<T> operation, final ProgressHandler handler, final ParamSpec[] specs) {
        Thread working = new Thread("processThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Core.this.operations.indexOf(operation) == -1) {
                    throw new RuntimeException("Core: not a registered operation");
                }
                Thread t = null;
                try {
                    Object operationInstance = ((Class)Core.this.operationAnnotatedClasses.get(operation)).newInstance();
                    final OperationKey key = new OperationKey();
                    key.operationInstance = operationInstance;
                    key.definition = operation;
                    try {
                        Core.this.validate(operation, operationInstance, specs);
                    }
                    catch (Throwable e) {
                        handler.validationError(e);
                        return;
                    }
                    if (specs == null) {
                        return;
                    }
                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                        for (ParamSpec spec : specs) {
                            logger.debug((Object)spec);
                        }
                    }
                    Executable ex = operation.makeExecutable(operationInstance, Core.this.pool, new Object[0]);
                    final SynchronousResultCollector collector = new SynchronousResultCollector();
                    final ExecutionSession session = ex.openExecutionSession(collector);
                    try {
                        if (operation.getMonitorBeanMethod() != null) {
                            Object monitorBean = operation.getMonitorBeanMethod().invoke(operationInstance, new Object[0]);
                            operationInstance = null;
                            if (handler != null) {
                                handler.operationStart(monitorBean, key);
                            }
                        } else if (handler != null) {
                            handler.operationStart(null, key);
                        }
                        t = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Vector<Lock> aquiredLocks = new Vector<Lock>();
                                class ClipboardItemNeed
                                implements Comparable<ClipboardItemNeed> {
                                    private ClipboardItem item;
                                    private char type;

                                    public ClipboardItemNeed(ClipboardItem item, char type) {
                                        this.item = item;
                                        this.type = type;
                                    }

                                    @Override
                                    public int compareTo(ClipboardItemNeed other) {
                                        return this.item.getID() - other.item.getID();
                                    }

                                    public boolean equals(Object o) {
                                        ClipboardItemNeed other = (ClipboardItemNeed)o;
                                        return this.item == other.item;
                                    }
                                }
                                Vector<ClipboardItemNeed> allNeeded = new Vector<ClipboardItemNeed>();
                                int i = 0;
                                for (IncomingEndPoint incomingEndPoint : session.getIncomingEndpoints()) {
                                    ClipboardItemNeed need;
                                    ClipboardItem item;
                                    Object value = specs[i].getRawValue();
                                    if (operation.getPorts().get(i).lock() && specs[i].getSource() == ParamSource.CLIPBOARD) {
                                        item = (ClipboardItem)specs[i].getValue();
                                        if (item != null) {
                                            need = new ClipboardItemNeed(item, 'w');
                                            if (allNeeded.indexOf(need) == -1) {
                                                allNeeded.add(need);
                                            } else {
                                                ClipboardItemNeed need2 = (ClipboardItemNeed)allNeeded.get(allNeeded.indexOf(need));
                                                if (need2.type == 'r') {
                                                    need2.type = 'w';
                                                }
                                            }
                                        }
                                    } else if (specs[i].getSource() == ParamSource.CLIPBOARD && (item = (ClipboardItem)specs[i].getValue()) != null && allNeeded.indexOf(need = new ClipboardItemNeed(item, 'r')) == -1) {
                                        allNeeded.add(need);
                                    }
                                    if (incomingEndPoint.getArgumentTypes().length == 0) {
                                        incomingEndPoint.call();
                                    }
                                    incomingEndPoint.call(value);
                                    ++i;
                                }
                                Collections.sort(allNeeded);
                                for (ClipboardItemNeed clipboardItemNeed : allNeeded) {
                                    Lock lk;
                                    if (clipboardItemNeed.type == 'r') {
                                        lk = clipboardItemNeed.item.getLock().readLock();
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)("Thread " + Thread.currentThread() + " trying to get READ lock " + lk + " item " + clipboardItemNeed.item));
                                        }
                                        lk.lock();
                                        aquiredLocks.add(lk);
                                        if (!logger.getEffectiveLevel().equals((Object)Level.DEBUG)) continue;
                                        logger.debug((Object)("Thread " + Thread.currentThread() + " aquired READ lock " + lk + " item " + clipboardItemNeed.item));
                                        continue;
                                    }
                                    lk = clipboardItemNeed.item.getLock().writeLock();
                                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                        logger.debug((Object)("Thread " + Thread.currentThread() + " trying to get WRITE lock " + lk + " item " + clipboardItemNeed.item));
                                    }
                                    lk.lock();
                                    aquiredLocks.add(lk);
                                    if (!logger.getEffectiveLevel().equals((Object)Level.DEBUG)) continue;
                                    logger.debug((Object)("Thread " + Thread.currentThread() + " aquired WRITE lock " + lk + " item " + clipboardItemNeed.item));
                                }
                                session.finish();
                                Vector<Object> allResults = new Vector<Object>();
                                ArrayList<ClipboardItem> arrayList = new ArrayList<ClipboardItem>();
                                try {
                                    Object results = collector.getResults();
                                    if (!key.cancelled) {
                                        ArrayList<Object> portOutputs = new ArrayList<Object>();
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)"Getting outputs and sending them to clipboard");
                                        }
                                        Iterator iterator = results.iterator();
                                        while (iterator.hasNext()) {
                                            List list = (List)iterator.next();
                                            for (Object elem : list) {
                                                portOutputs.add(elem);
                                                allResults.add(elem);
                                                arrayList.addAll(Core.this.getClipboard().putItem(elem, null));
                                            }
                                        }
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)"Creating a new History item");
                                        }
                                        Core.this.getHistory().putHistoryElement(specs, operation, arrayList, portOutputs);
                                        results = null;
                                        portOutputs = null;
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    if (handler != null) {
                                        handler.operationError(e);
                                        handler.operationFinished(allResults, arrayList);
                                    }
                                    Core.this.gui.error(e);
                                }
                                finally {
                                    for (Lock lk : aquiredLocks) {
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)("Thread " + Thread.currentThread() + " releasing lock: " + lk));
                                        }
                                        lk.unlock();
                                    }
                                    if (handler != null) {
                                        handler.operationFinished(allResults, arrayList);
                                    }
                                    allResults = null;
                                    Core.this.decreaseRunningCount();
                                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                        logger.debug((Object)"Operation finished");
                                    }
                                }
                            }
                        };
                        t.start();
                        Core.this.increaseRunningCount();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        if (t != null) {
                            t.interrupt();
                        }
                        if (handler != null) {
                            handler.operationFinished(null, null);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        if (handler != null) {
                            handler.operationFinished(null, null);
                        }
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        if (handler != null) {
                            handler.operationFinished(null, null);
                        }
                    }
                    catch (Exception e) {
                        if (t != null) {
                            t.interrupt();
                        }
                        if (handler != null) {
                            handler.operationFinished(null, null);
                        }
                    }
                    Core.getInstance().getGUI().update();
                    if (Core.this.gui != null) {
                        Core.this.gui.update();
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    if (t != null) {
                        t.interrupt();
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        };
        working.start();
    }

    public void executeOperation(String opName, ProgressHandler handler, List<?> params) {
        OperationDefinition<?> op = this.getOperationById(opName);
        if (op == null) {
            return;
        }
        ParamSpec[] paramsSpecs = CoreUtils.createParams(params);
        this.executeOperation(op, handler, paramsSpecs);
    }

    private void increaseRunningCount() {
        ++this.runningCount;
        this.getGUI().setStatusText("Core Running " + this.runningCount + " operations");
    }

    private void decreaseRunningCount() {
        --this.runningCount;
        if (this.runningCount == 0) {
            this.getGUI().setStatusText("AIBench");
        } else {
            this.getGUI().setStatusText("Core Running " + this.runningCount + " operations");
        }
    }

    public synchronized void cancelOperation(Object key) {
        OperationKey _key = (OperationKey)key;
        Method cancel = _key.definition.getCancelMethod();
        if (cancel != null) {
            try {
                cancel.invoke(_key.operationInstance, (Object[])null);
                _key.cancelled = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableOperation(String uid) {
        this.enableOperation(this.getOperationById(uid));
    }

    public void enableOperation(OperationDefinition<?> def) {
        this.enabledOperations.add(def);
        for (CoreListener listener : this.coreListeners) {
            listener.operationEnabled(def);
        }
    }

    public void disableOperation(String uid) {
        this.disableOperation(this.getOperationById(uid));
    }

    public void disableOperation(OperationDefinition<?> def) {
        this.enabledOperations.remove(def);
        for (CoreListener listener : this.coreListeners) {
            listener.operationDisabled(def);
        }
    }

    public boolean isOperationEnabled(OperationDefinition<?> def) {
        return this.enabledOperations.contains(def);
    }

    private static void readConfig() {
        String path = System.getProperty("aibench.paths.core.conf", "conf/core.conf");
        URL url = Util.getGlobalResourceURL((String)path);
        try {
            CONFIG.load(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class OperationKey {
        Object operationInstance;
        OperationDefinition<?> definition;
        boolean cancelled = false;

        OperationKey() {
        }
    }
}

