/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine.version;

import java.util.regex.Pattern;
import org.platonos.pluginengine.PluginEngineException;
import org.platonos.pluginengine.version.PluginDependencyMinMaxVersion;
import org.platonos.pluginengine.version.PluginDependencySingleVersion;
import org.platonos.pluginengine.version.PluginInstanceVersion;

public abstract class PluginVersion
implements Comparable<PluginVersion> {
    public static final String TEXT_VERSION_PATTERN = "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+)?)?";
    public static final String TEXT_INSTANCE_VERSION_PATTERN = "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+(\\p{Space}+\\p{Digit}+)?)?)?";
    public static final String TEXT_INTERVAL_VERSION_PATTERN = String.format("%s,%s", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+)?)?", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+)?)?");
    public static final String TEXT_MIN_VERSION_PATTERN = "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+-?|-)?|-)?";
    public static final String TEXT_MAX_VERSION_PATTERN = "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+|\\+?||\\+)?|\\+)?";
    public static final Pattern VERSION_PATTERN = Pattern.compile(String.format("^%s$", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+)?)?"));
    public static final Pattern INSTANCE_VERSION_PATTERN = Pattern.compile(String.format("^%s$", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+(\\p{Space}+\\p{Digit}+)?)?)?"));
    public static final Pattern INTERVAL_VERSION_PATTERN = Pattern.compile(String.format("^%s$", TEXT_INTERVAL_VERSION_PATTERN));
    public static final Pattern MIN_VERSION_PATTERN = Pattern.compile(String.format("^%s$", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+-?|-)?|-)?"));
    public static final Pattern MAX_VERSION_PATTERN = Pattern.compile(String.format("^%s$", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+|\\+?||\\+)?|\\+)?"));

    public static final boolean isValidInstanceVersion(String version) {
        return INSTANCE_VERSION_PATTERN.matcher(version).matches();
    }

    public static final boolean isValidDependencyVersion(String version) {
        return VERSION_PATTERN.matcher(version).matches() || INTERVAL_VERSION_PATTERN.matcher(version).matches() || MIN_VERSION_PATTERN.matcher(version).matches() || MAX_VERSION_PATTERN.matcher(version).matches();
    }

    public static final PluginVersion createDependencyVersion(String version) throws PluginEngineException {
        String cleanVersion;
        PluginVersion maxVersion;
        if (VERSION_PATTERN.matcher(version).matches()) {
            String[] versions = version.split("\\.");
            try {
                switch (versions.length) {
                    case 1: {
                        return new PluginDependencySingleVersion(Integer.parseInt(versions[0]));
                    }
                    case 2: {
                        return new PluginDependencySingleVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]));
                    }
                    case 3: {
                        return new PluginDependencySingleVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]), Integer.parseInt(versions[2]));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (INTERVAL_VERSION_PATTERN.matcher(version).matches()) {
            String[] versions = version.split(",");
            if (versions.length == 2) {
                PluginVersion minVersion = PluginVersion.createDependencyVersion(versions[0]);
                PluginVersion maxVersion2 = PluginVersion.createDependencyVersion(versions[1]);
                if (minVersion instanceof PluginDependencySingleVersion && maxVersion2 instanceof PluginDependencySingleVersion) {
                    return new PluginDependencyMinMaxVersion((PluginDependencySingleVersion)minVersion, (PluginDependencySingleVersion)maxVersion2);
                }
            }
        } else if (MIN_VERSION_PATTERN.matcher(version).matches()) {
            String cleanVersion2 = version.substring(0, version.length() - 1);
            PluginVersion minVersion = PluginVersion.createDependencyVersion(cleanVersion2);
            if (minVersion instanceof PluginDependencySingleVersion) {
                return new PluginDependencyMinMaxVersion((PluginDependencySingleVersion)minVersion, PluginDependencyMinMaxVersion.Type.MIN);
            }
        } else if (MAX_VERSION_PATTERN.matcher(version).matches() && (maxVersion = PluginVersion.createDependencyVersion(cleanVersion = version.substring(0, version.length() - 1))) instanceof PluginDependencySingleVersion) {
            return new PluginDependencyMinMaxVersion((PluginDependencySingleVersion)maxVersion, PluginDependencyMinMaxVersion.Type.MAX);
        }
        throw new PluginEngineException("Invalid instance version: " + version);
    }

    public static final PluginVersion createInstanceVersion(String version) throws PluginEngineException {
        if (PluginVersion.isValidInstanceVersion(version)) {
            String cleanVersion = version.replaceAll("\\p{Space}+", ".");
            String[] versions = cleanVersion.split("\\.");
            try {
                switch (versions.length) {
                    case 1: {
                        return new PluginInstanceVersion(Integer.parseInt(versions[0]));
                    }
                    case 2: {
                        return new PluginInstanceVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]));
                    }
                    case 3: {
                        return new PluginInstanceVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]), Integer.parseInt(versions[2]));
                    }
                    case 4: {
                        return new PluginInstanceVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]), Integer.parseInt(versions[2]), versions[3]);
                    }
                }
                throw new PluginEngineException("Invalid instance version: " + version);
            }
            catch (NumberFormatException nfe) {
                throw new PluginEngineException("Invalid instance version: " + version);
            }
        }
        throw new PluginEngineException("Invalid instance version: " + version);
    }

    public abstract String getFullVersion();

    @Override
    public final int compareTo(PluginVersion requiredVersion) {
        if (requiredVersion instanceof PluginInstanceVersion) {
            return this.compareTo((PluginInstanceVersion)requiredVersion);
        }
        if (requiredVersion instanceof PluginDependencySingleVersion) {
            return this.compareTo((PluginDependencySingleVersion)requiredVersion);
        }
        if (requiredVersion instanceof PluginDependencyMinMaxVersion) {
            return this.compareTo((PluginDependencyMinMaxVersion)requiredVersion);
        }
        return 0;
    }

    @Override
    public abstract int compareTo(PluginDependencyMinMaxVersion var1);

    @Override
    public abstract int compareTo(PluginDependencySingleVersion var1);

    @Override
    public abstract int compareTo(PluginInstanceVersion var1);
}

