/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine.version;

import org.platonos.pluginengine.version.PluginDependencyMinMaxVersion;
import org.platonos.pluginengine.version.PluginInstanceVersion;
import org.platonos.pluginengine.version.PluginSingleVersion;

public final class PluginDependencySingleVersion
extends PluginSingleVersion {
    public PluginDependencySingleVersion() {
    }

    public PluginDependencySingleVersion(int releaseVersion) {
        super(releaseVersion);
    }

    public PluginDependencySingleVersion(int releaseVersion, int updateVersion) {
        super(releaseVersion, updateVersion);
    }

    public PluginDependencySingleVersion(int releaseVersion, int updateVersion, int patchVersion) {
        super(releaseVersion, updateVersion, patchVersion);
    }

    @Override
    public int compareTo(PluginDependencyMinMaxVersion version) {
        return -version.compareTo(this);
    }

    @Override
    public int compareTo(PluginDependencySingleVersion version) {
        int thisRelease = this.getReleaseVersion();
        int otherRelease = version.getReleaseVersion();
        if (thisRelease == -1 || otherRelease == -1) {
            return 0;
        }
        if (thisRelease == otherRelease) {
            int thisUpdate = this.getUpdateVersion();
            int otherUpdate = version.getUpdateVersion();
            if (thisUpdate == -1 || otherUpdate == -1) {
                return 0;
            }
            if (thisUpdate == otherUpdate) {
                int thisPatch = this.getPatchVersion();
                int otherPatch = version.getPatchVersion();
                if (thisPatch == -1 || otherPatch == -1 || thisPatch == otherPatch) {
                    return 0;
                }
                return thisPatch < otherPatch ? -1 : 1;
            }
            return thisUpdate < otherUpdate ? -1 : 1;
        }
        return thisRelease < otherRelease ? -1 : 1;
    }

    @Override
    public int compareTo(PluginInstanceVersion version) {
        int thisRelease = this.getReleaseVersion();
        int otherRelease = version.getReleaseVersion();
        if (thisRelease == -1) {
            return 0;
        }
        if (thisRelease == otherRelease) {
            int thisUpdate = this.getUpdateVersion();
            int otherUpdate = version.getUpdateVersion();
            if (thisUpdate == -1) {
                return 0;
            }
            if (thisUpdate == otherUpdate) {
                int thisPatch = this.getPatchVersion();
                int otherPatch = version.getPatchVersion();
                if (thisPatch == -1 || thisPatch == otherPatch) {
                    return 0;
                }
                return thisPatch < otherPatch ? -1 : 1;
            }
            return thisUpdate < otherUpdate ? -1 : 1;
        }
        return thisRelease < otherRelease ? -1 : 1;
    }

    public boolean equals(Object object) {
        if (object instanceof PluginDependencySingleVersion) {
            PluginDependencySingleVersion version = (PluginDependencySingleVersion)object;
            return version.getReleaseVersion() == this.getReleaseVersion() && version.getUpdateVersion() == this.getUpdateVersion() && version.getPatchVersion() == this.getPatchVersion();
        }
        return false;
    }

    public String toString() {
        String release = this.getReleaseVersion() < 0 ? "*" : Integer.toString(this.getReleaseVersion());
        String update = this.getUpdateVersion() < 0 ? "*" : Integer.toString(this.getUpdateVersion());
        String patch = this.getPatchVersion() < 0 ? "*" : Integer.toString(this.getPatchVersion());
        return String.format("%s.%s.%s", release, update, patch);
    }
}

