/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine.version;

import org.platonos.pluginengine.version.PluginDependencySingleVersion;
import org.platonos.pluginengine.version.PluginInstanceVersion;
import org.platonos.pluginengine.version.PluginVersion;

public final class PluginDependencyMinMaxVersion
extends PluginVersion {
    private final PluginDependencySingleVersion minVersion;
    private final PluginDependencySingleVersion maxVersion;

    public PluginDependencyMinMaxVersion(PluginDependencySingleVersion version, Type type) {
        if (version == null) {
            throw new NullPointerException("Invalid argument: version");
        }
        this.minVersion = type == Type.MIN ? version : null;
        this.maxVersion = type == Type.MAX ? version : null;
    }

    public PluginDependencyMinMaxVersion(PluginDependencySingleVersion minVersion, PluginDependencySingleVersion maxVersion) {
        if (minVersion == null) {
            throw new NullPointerException("Invalid argument: minVersion");
        }
        if (maxVersion == null) {
            throw new NullPointerException("Invalid argument: maxVersion");
        }
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public PluginDependencySingleVersion getMinVersion() {
        return this.minVersion;
    }

    public PluginDependencySingleVersion getMaxVersion() {
        return this.maxVersion;
    }

    @Override
    public String getFullVersion() {
        return this.toString();
    }

    @Override
    public int compareTo(PluginDependencyMinMaxVersion version) {
        PluginDependencySingleVersion thisMinVersion = this.getMinVersion();
        PluginDependencySingleVersion thisMaxVersion = this.getMaxVersion();
        PluginDependencySingleVersion otherMinVersion = version.getMinVersion();
        PluginDependencySingleVersion otherMaxVersion = version.getMaxVersion();
        if (thisMinVersion == null) {
            if (otherMinVersion == null || this.getMaxVersion().compareTo(otherMinVersion) >= 0) {
                return 0;
            }
            return -1;
        }
        if (thisMaxVersion == null) {
            if (otherMaxVersion == null || this.getMinVersion().compareTo(otherMaxVersion) <= 0) {
                return 0;
            }
            return -1;
        }
        if (otherMinVersion != null && this.maxVersion.compareTo(otherMinVersion) < 0) {
            return -1;
        }
        if (otherMaxVersion != null && this.minVersion.compareTo(otherMaxVersion) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(PluginDependencySingleVersion version) {
        int cmpMaxVersion;
        int cmpMinVersion;
        if (this.getMinVersion() != null && (cmpMinVersion = version.compareTo(this.getMinVersion())) <= 0) {
            return cmpMinVersion;
        }
        if (this.getMaxVersion() != null && (cmpMaxVersion = version.compareTo(this.getMaxVersion())) >= 0) {
            return cmpMaxVersion;
        }
        return 0;
    }

    @Override
    public int compareTo(PluginInstanceVersion version) {
        PluginDependencySingleVersion thisMinVersion = this.getMinVersion();
        PluginDependencySingleVersion thisMaxVersion = this.getMaxVersion();
        if (thisMinVersion == null) {
            return Math.min(thisMaxVersion.compareTo(version), 0);
        }
        if (thisMaxVersion == null) {
            return Math.max(thisMinVersion.compareTo(version), 0);
        }
        if (thisMaxVersion.compareTo(version) >= 0) {
            return Math.max(thisMinVersion.compareTo(version), 0);
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PluginDependencyMinMaxVersion) {
            PluginDependencyMinMaxVersion version = (PluginDependencyMinMaxVersion)obj;
            if (this.getMinVersion() == null && version.getMinVersion() == null) {
                return this.getMaxVersion().equals(version.getMaxVersion());
            }
            if (this.getMaxVersion() == null && version.getMaxVersion() == null) {
                return this.getMinVersion().equals(version.getMinVersion());
            }
            return this.getMaxVersion().equals(version.getMaxVersion()) && this.getMinVersion().equals(version.getMinVersion());
        }
        return false;
    }

    public String toString() {
        if (this.getMinVersion() != null && this.getMaxVersion() != null) {
            return String.format("%s, %s", this.getMinVersion().toString(), this.getMaxVersion().toString());
        }
        if (this.getMinVersion() != null) {
            return String.format("%s+", this.getMinVersion());
        }
        return String.format("%s-", this.getMaxVersion());
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

