/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.platonos.pluginengine.IPluginConfiguration;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.logging.DefaultLogger;
import org.platonos.pluginengine.logging.ILogger;
import org.platonos.pluginengine.logging.LoggerLevel;

public class PluginFileConfiguration
implements IPluginConfiguration {
    private static final ILogger logger = new DefaultLogger();
    private static final String DEFAULT_OPTION_ENABLED = "enabled";
    private static final String DEFAULT_OPTION_LOAD = "load";
    private static final String DEFAULT_OPTION_ACTIVE = "active";
    private final Properties properties = new Properties();
    private final URL configurationFile;
    private final String enabledSuffix;
    private final String loadSuffix;
    private final String activeSuffix;
    private final boolean enabledByDefault;
    private final boolean loadByDefault;
    private final boolean activeByDefault;

    public PluginFileConfiguration(URL configurationFile) throws IOException {
        this(configurationFile, DEFAULT_OPTION_LOAD, DEFAULT_OPTION_ENABLED, DEFAULT_OPTION_ACTIVE);
    }

    public PluginFileConfiguration(URL configurationFile, String loadSuffix, String enabledSuffix, String activeSuffix) throws IOException {
        this.configurationFile = configurationFile;
        this.loadSuffix = loadSuffix;
        this.enabledSuffix = enabledSuffix;
        this.activeSuffix = activeSuffix;
        InputStream fis = configurationFile.openStream();
        this.properties.load(fis);
        fis.close();
        this.enabledByDefault = Boolean.parseBoolean(this.properties.getProperty("default.enabled", "true"));
        this.loadByDefault = Boolean.parseBoolean(this.properties.getProperty("default.load", "true"));
        this.activeByDefault = Boolean.parseBoolean(this.properties.getProperty("default.active", "true"));
    }

    public PluginFileConfiguration(File configurationFile) throws IOException {
        this(configurationFile.toURI().toURL());
    }

    public PluginFileConfiguration(File configurationFile, String loadSuffix, String enabledSuffix, String activeSuffix) throws IOException {
        this(configurationFile.toURI().toURL(), loadSuffix, enabledSuffix, activeSuffix);
    }

    private void storeProperties() {
        try {
            OutputStream os = this.configurationFile.openConnection().getOutputStream();
            this.properties.store(os, null);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            logger.log(LoggerLevel.WARNING, "Plugin configuration file couldn't be modified.", e);
        }
    }

    @Override
    public boolean isLoadPlugin(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return this.isLoadPlugin(plugin.getUID());
    }

    @Override
    public boolean isLoadPlugin(String pluginUID) {
        return Boolean.parseBoolean(this.properties.getProperty(String.format("%s.%s", pluginUID, this.loadSuffix), Boolean.toString(this.loadByDefault)));
    }

    @Override
    public boolean isEnabledPlugin(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return this.isEnabledPlugin(plugin.getUID());
    }

    @Override
    public boolean isEnabledPlugin(String pluginUID) {
        return Boolean.parseBoolean(this.properties.getProperty(String.format("%s.%s", pluginUID, this.enabledSuffix), Boolean.toString(this.enabledByDefault)));
    }

    @Override
    public boolean isActivePlugin(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return this.isActivePlugin(plugin.getUID());
    }

    @Override
    public boolean isActivePlugin(String pluginUID) {
        return Boolean.parseBoolean(this.properties.getProperty(String.format("%s.%s", pluginUID, this.activeSuffix), Boolean.toString(this.activeByDefault)));
    }

    @Override
    public void setLoadPlugin(Plugin plugin, boolean value) {
        this.setLoadPlugin(plugin.getUID(), value);
    }

    @Override
    public void setLoadPlugin(String pluginUID, boolean value) {
        this.properties.setProperty(String.format("%s.%s", pluginUID, this.loadSuffix), Boolean.toString(value));
        this.storeProperties();
    }

    @Override
    public void setEnabledPlugin(Plugin plugin, boolean value) {
        this.setEnabledPlugin(plugin.getUID(), value);
    }

    @Override
    public void setEnabledPlugin(String pluginUID, boolean value) {
        this.properties.setProperty(String.format("%s.%s", pluginUID, this.enabledSuffix), Boolean.toString(value));
        this.storeProperties();
    }

    @Override
    public void setActivePlugin(Plugin plugin, boolean value) {
        this.setActivePlugin(plugin.getUID(), value);
    }

    @Override
    public void setActivePlugin(String pluginUID, boolean value) {
        this.properties.setProperty(String.format("%s.%s", pluginUID, this.activeSuffix), Boolean.toString(value));
        this.storeProperties();
    }
}

