/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.platonos.pluginengine.Dependency;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.ExtensionClassLoader;
import org.platonos.pluginengine.ExtensionPoint;
import org.platonos.pluginengine.IPluginConfiguration;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginClassLoader;
import org.platonos.pluginengine.PluginEngineException;
import org.platonos.pluginengine.PluginFileConfiguration;
import org.platonos.pluginengine.PluginXmlParser;
import org.platonos.pluginengine.StartPluginQueue;
import org.platonos.pluginengine.event.IPluginEngineListener;
import org.platonos.pluginengine.event.PluginEngineEvent;
import org.platonos.pluginengine.event.PluginEngineEventType;
import org.platonos.pluginengine.logging.DefaultLogger;
import org.platonos.pluginengine.logging.ILogger;
import org.platonos.pluginengine.logging.LoggerLevel;
import org.platonos.pluginengine.version.PluginVersion;

public final class PluginEngine {
    private final IPluginConfiguration configuration;
    private final String uid;
    private boolean engineStarted = false;
    private final ILogger logger;
    StartPluginQueue startPluginQueue;
    int startPluginThreadCount = 3;
    private String tempDirectory;
    private final Map<String, List<Plugin>> plugins = new HashMap<String, List<Plugin>>(50);
    private final List<Plugin> unloadedPlugins = new ArrayList<Plugin>(10);
    private final List<Plugin> unresolvedPlugins = new ArrayList<Plugin>(50);
    private final List<Dependency> unresolvedDependencies = new ArrayList<Dependency>(50);
    private final List<String> archiveExtensions = new ArrayList<String>(5);
    private final Map<String, String> tokens = new HashMap<String, String>(100);
    private final List<IPluginEngineListener> pluginEngineListeners = new ArrayList<IPluginEngineListener>(2);
    final FileFilter archiveFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            for (String extension : PluginEngine.this.getArchiveExtensions()) {
                if (!name.toLowerCase().endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    };
    private final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public PluginEngine(String uid) {
        this(uid, (IPluginConfiguration)null, (ILogger)new DefaultLogger());
    }

    public PluginEngine(String uid, ILogger logger) {
        this(uid, (IPluginConfiguration)null, logger);
    }

    public PluginEngine(String uid, File configurationFile) {
        this(uid, configurationFile, (ILogger)new DefaultLogger());
    }

    public PluginEngine(String uid, File configurationFile, ILogger logger) {
        if (uid == null) {
            throw new NullPointerException("Invalid argument: uid");
        }
        if (logger == null) {
            throw new NullPointerException("Invalid argument: logger");
        }
        this.uid = uid;
        this.logger = logger;
        PluginFileConfiguration configuration = null;
        try {
            configuration = new PluginFileConfiguration(configurationFile);
        }
        catch (Exception e) {
            configuration = null;
            this.logger.log(LoggerLevel.WARNING, String.format("Invalid configuration file: %s.", configurationFile), e);
        }
        this.configuration = configuration;
        this.tempDirectory = String.format("%s%splatonos%s%s%s", System.getProperty("java.io.tmpdir"), File.separator, File.separator, uid, File.separator);
        if (!PluginXmlParser.isValidationSupported()) {
            logger.log(LoggerLevel.FINE, "SAX parser does not support JAXP 1.2. Extension XML and plugin.xml files cannot be validated.", null);
        }
    }

    public PluginEngine(String uid, IPluginConfiguration configuration) {
        this(uid, configuration, (ILogger)new DefaultLogger());
    }

    public PluginEngine(String uid, IPluginConfiguration configuration, ILogger logger) {
        if (uid == null) {
            throw new NullPointerException("Invalid argument: uid");
        }
        if (logger == null) {
            throw new NullPointerException("Invalid argument: logger");
        }
        this.uid = uid;
        this.configuration = configuration;
        this.logger = logger;
        this.tempDirectory = String.format("%s%splatonos%s%s%s", System.getProperty("java.io.tmpdir"), File.separator, File.separator, uid, File.separator);
        if (!PluginXmlParser.isValidationSupported()) {
            logger.log(LoggerLevel.FINE, "SAX parser does not support JAXP 1.2. Extension XML and plugin.xml files cannot be validated.", null);
        }
    }

    private boolean isLoadPlugin(Plugin plugin) {
        return this.configuration == null || this.configuration.isLoadPlugin(plugin);
    }

    private boolean isEnabledPlugin(Plugin plugin) {
        return this.configuration == null || this.configuration.isEnabledPlugin(plugin);
    }

    private boolean isActivePlugin(Plugin plugin) {
        return this.configuration == null || this.configuration.isActivePlugin(plugin);
    }

    public void start() {
        this.startPluginQueue = new StartPluginQueue(this);
        this.getLogger().log(LoggerLevel.INFO, "PluginEngine started.", null);
        if (this.plugins.values().isEmpty()) {
            this.getLogger().log(LoggerLevel.FINE, "No Plugins were found.", null);
        } else {
            this.resolvePlugins();
        }
        this.engineStarted = true;
        this.firePluginEngineEvent(new PluginEngineEvent(PluginEngineEventType.STARTUP, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        PluginEngine pluginEngine = this;
        synchronized (pluginEngine) {
            if (!this.engineStarted) {
                return;
            }
            this.engineStarted = false;
        }
        for (Plugin plugin : this.getPlugins()) {
            this.unloadPlugin(plugin);
        }
        this.startPluginQueue.shutdown();
        this.getLogger().log(LoggerLevel.INFO, "PluginEngine shutdown.", null);
        this.firePluginEngineEvent(new PluginEngineEvent(PluginEngineEventType.SHUTDOWN, this));
    }

    public void loadPlugin(File location) throws PluginEngineException {
        if (location == null) {
            throw new NullPointerException("Invalid argument: location");
        }
        if (!location.exists()) {
            throw new PluginEngineException("Plugin location doesn't not exist: " + location);
        }
        if (location.isDirectory()) {
            File pluginXML = new File(location, "plugin.xml");
            if (!pluginXML.exists()) {
                throw new PluginEngineException("Error getting plugin.xml URL for Plugin directory: " + location, null);
            }
            this.loadPluginXML(pluginXML);
        } else {
            URL pluginXmlUrl;
            try {
                pluginXmlUrl = new URL("jar", "", "file:" + location.getAbsolutePath() + "!/plugin.xml");
            }
            catch (MalformedURLException ex) {
                return;
            }
            this.loadPluginXML(pluginXmlUrl);
        }
    }

    public void loadPlugin(String location) throws PluginEngineException {
        if (location == null) {
            throw new NullPointerException("Invalid argument: location");
        }
        this.loadPlugin(new File(location));
    }

    public void loadPlugins(File directory) {
        if (directory == null) {
            throw new NullPointerException("Invalid argument: directory");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Plugin directory does not exist: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("The specified File must be a directory: " + directory.getAbsolutePath());
        }
        try {
            this.loadPlugin(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        File[] pluginArchives = directory.listFiles(this.archiveFilter);
        for (int i = 0; i < pluginArchives.length; ++i) {
            try {
                this.loadPlugin(pluginArchives[i]);
                continue;
            }
            catch (PluginEngineException ex) {
                this.logger.log(LoggerLevel.SEVERE, "Error loading Plugin archive in directory: " + directory.getAbsolutePath(), ex);
            }
        }
        File[] directories = directory.listFiles(this.directoryFilter);
        for (int i = 0; i < directories.length; ++i) {
            File pluginXML = new File(directories[i], "plugin.xml");
            if (!pluginXML.exists()) continue;
            try {
                this.loadPluginXML(pluginXML);
                continue;
            }
            catch (PluginEngineException ex) {
                this.logger.log(LoggerLevel.SEVERE, "Error loading Plugin in directory: " + directory.getAbsolutePath(), ex);
            }
        }
    }

    public void loadPlugins(String directory) {
        if (directory == null) {
            throw new NullPointerException("Invalid argument: directory");
        }
        this.loadPlugins(new File(directory));
    }

    private void loadPluginXML(File pluginXML) throws PluginEngineException {
        URL pluginXmlURL;
        try {
            pluginXmlURL = pluginXML.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new PluginEngineException("Error getting URL for plugin.xml file: " + pluginXML, ex);
        }
        this.loadPluginXML(pluginXmlURL);
    }

    private void loadPluginXML(URL pluginXmlURL) throws PluginEngineException {
        Plugin plugin = null;
        try {
            plugin = PluginXmlParser.parse(this, pluginXmlURL);
        }
        catch (PluginEngineException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                this.logger.log(LoggerLevel.FINE, "Ignoring .jar due to lack of plugin.xml", null);
                return;
            }
            throw e;
        }
        if (plugin == null) {
            throw new PluginEngineException("Error parsing plugin.xml at URL: " + pluginXmlURL, null);
        }
        this.loadPlugin(plugin);
    }

    public void loadPlugin(Plugin plugin) throws PluginEngineException {
        if (plugin == null) {
            throw new NullPointerException("Invalid argument: plugin");
        }
        if (plugin.getUID() == null) {
            throw new IllegalArgumentException("Plugin must have a UID.");
        }
        if (plugin.getPluginEngine() != this) {
            throw new IllegalArgumentException("Plugin is for the wrong PluginEngine instance: " + plugin.getUID());
        }
        if (plugin.isLoaded()) {
            return;
        }
        if (this.isLoadPlugin(plugin)) {
            String pluginUID = plugin.getUID();
            List<Plugin> pluginList = this.plugins.get(pluginUID);
            if (pluginList == null) {
                pluginList = new ArrayList<Plugin>(1);
                this.plugins.put(pluginUID, pluginList);
            } else {
                for (Plugin existingPlugin : pluginList) {
                    if (!existingPlugin.getVersion().equals(plugin.getVersion())) continue;
                    throw new PluginEngineException("Ignoring already loaded plugin \"" + pluginUID + "\", version \"" + plugin.getVersion() + "\".");
                }
            }
            pluginList.add(plugin);
            Collections.sort(pluginList, Collections.reverseOrder());
            plugin.isLoaded = true;
            this.getLogger().log(LoggerLevel.FINE, "Loading Plugin: " + plugin, null);
            PluginEngineEvent event = new PluginEngineEvent(PluginEngineEventType.PLUGIN_LOADED, this);
            event.setPayload(plugin);
            this.firePluginEngineEvent(event);
            plugin.isActive = this.isActivePlugin(plugin);
            if (this.isEnabledPlugin(plugin)) {
                this.unresolvedPlugins.add(plugin);
                if (this.engineStarted) {
                    this.resolvePlugins();
                }
            } else {
                plugin.isDisabled = true;
                this.getLogger().log(LoggerLevel.FINE, "Plugin not loaded by configuration: " + plugin, null);
                event = new PluginEngineEvent(PluginEngineEventType.PLUGIN_DISABLED, this);
                event.setPayload(plugin);
                this.firePluginEngineEvent(event);
            }
        } else {
            plugin.isLoaded = false;
            plugin.isActive = false;
            plugin.isDisabled = !this.isEnabledPlugin(plugin);
            this.unloadedPlugins.add(plugin);
        }
    }

    private synchronized void resolvePlugins() {
        HashSet<Plugin> resolvablePlugins = new HashSet<Plugin>();
        Iterator<Object> iter = this.unresolvedPlugins.iterator();
        while (iter.hasNext()) {
            Plugin plugin = iter.next();
            if (!this.isResolvable(plugin, new HashSet<Plugin>(resolvablePlugins))) continue;
            iter.remove();
            resolvablePlugins.add(plugin);
            plugin.isResolved = true;
        }
        for (Plugin plugin : resolvablePlugins) {
            this.logger.log(LoggerLevel.FINE, "Resolving Plugin: " + plugin, null);
            for (Dependency dependency : plugin.getDependencies()) {
                Plugin resolveToPlugin = this.getPlugin(dependency);
                if (resolveToPlugin == null || !resolveToPlugin.isResolved) {
                    this.unresolvedDependencies.add(dependency);
                    continue;
                }
                dependency.resolve(resolveToPlugin);
            }
        }
        iter = this.unresolvedDependencies.iterator();
        while (iter.hasNext()) {
            Dependency dependency = (Dependency)iter.next();
            Plugin resolveToPlugin = this.getPlugin(dependency);
            if (resolveToPlugin == null) continue;
            iter.remove();
            dependency.resolve(resolveToPlugin);
        }
        for (Plugin plugin : resolvablePlugins) {
            for (Plugin dependentPlugin : plugin.getDependentPlugins()) {
                this.resolveExtensions(dependentPlugin);
            }
            this.resolveExtensions(plugin);
            PluginEngineEvent engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_RESOLVED, this);
            engineEvent.setPayload(plugin);
            this.firePluginEngineEvent(engineEvent);
        }
        ArrayList startOrderResolvablePlugins = new ArrayList(resolvablePlugins);
        Collections.sort(startOrderResolvablePlugins, StartPluginQueue.PLUGIN_START_ORDER_COMPARATOR);
        for (Plugin plugin : startOrderResolvablePlugins) {
            if (!plugin.getStartWhenResolved()) continue;
            plugin.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isResolvable(Plugin plugin, Set<Plugin> ignorePlugins) {
        ignorePlugins.add(plugin);
        try {
            for (Dependency dependency : plugin.getDependencies()) {
                if (dependency.isOptional()) continue;
                Plugin resolveToPlugin = plugin.getPluginEngine().getPlugin(dependency);
                if (resolveToPlugin == null) {
                    boolean bl = false;
                    return bl;
                }
                if (resolveToPlugin.isResolved() || ignorePlugins.contains(resolveToPlugin) || this.isResolvable(resolveToPlugin, ignorePlugins)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ignorePlugins.remove(plugin);
        }
    }

    private void resolveExtensions(Plugin plugin) {
        for (Extension extension : plugin.getExtensions()) {
            ExtensionPoint extensionPoint;
            Dependency dependency;
            if (extension.getExtensionPoint() != null || !(dependency = plugin.getDependency(extension.getExtensionPointPluginUID())).isResolved() || (extensionPoint = dependency.getResolvedToPlugin().getExtensionPoint(extension.getExtensionPointName())) == null) continue;
            extension.resolve(extensionPoint);
        }
    }

    synchronized void unresolvePlugin(Plugin plugin, boolean resolveAgain) {
        this.unresolvePlugin(plugin, new HashSet<Plugin>());
        if (resolveAgain) {
            this.resolvePlugins();
        }
    }

    synchronized void unresolvePlugin(Plugin plugin, Set<Plugin> unresolvingPlugins) {
        if (!plugin.isResolved()) {
            return;
        }
        PluginEngineEvent engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_UNRESOLVED, this);
        engineEvent.setPayload(plugin);
        this.firePluginEngineEvent(engineEvent);
        unresolvingPlugins.add(plugin);
        String pluginUID = plugin.getUID();
        for (Plugin dependentPlugin : plugin.getDependentPlugins()) {
            if (!dependentPlugin.isResolved()) continue;
            Dependency dependency = dependentPlugin.getDependency(pluginUID);
            if (dependency.isOptional()) {
                dependency.unresolve();
                this.unresolvedDependencies.add(dependency);
                continue;
            }
            if (unresolvingPlugins.contains(dependentPlugin)) continue;
            this.logger.log(LoggerLevel.FINE, "Unresolving Plugin with a required dependency: " + dependentPlugin, null);
            this.unresolvePlugin(dependentPlugin, unresolvingPlugins);
        }
        unresolvingPlugins.remove(plugin);
        for (Extension extension : plugin.getExtensions()) {
            if (extension.getExtensionPoint() == null) continue;
            extension.unresolve();
        }
        for (ExtensionPoint extensionPoint : plugin.getExtensionPoints()) {
            for (Extension extension : extensionPoint.getExtensions()) {
                extension.unresolve();
            }
        }
        plugin.stop();
        for (Dependency dependency : plugin.getDependencies()) {
            if (dependency.isResolved()) {
                dependency.unresolve();
                continue;
            }
            this.unresolvedDependencies.remove(dependency);
        }
        plugin.pluginClassloader = PluginClassLoader.createClassLoader(plugin);
        System.gc();
        plugin.isResolved = false;
        this.unresolvedPlugins.add(plugin);
    }

    public synchronized void disablePlugin(Plugin plugin) {
        if (plugin.isDisabled()) {
            return;
        }
        this.getLogger().log(LoggerLevel.FINE, "Disabling Plugin: " + plugin, null);
        this.unresolvePlugin(plugin, false);
        this.unresolvedPlugins.remove(plugin);
        plugin.isDisabled = true;
        PluginEngineEvent event = new PluginEngineEvent(PluginEngineEventType.PLUGIN_DISABLED, this);
        event.setPayload(plugin);
        this.firePluginEngineEvent(event);
    }

    public synchronized void enablePlugin(Plugin plugin) {
        if (!plugin.isDisabled()) {
            return;
        }
        plugin.isDisabled = false;
        this.getLogger().log(LoggerLevel.FINE, "Enabling Plugin: " + plugin, null);
        PluginEngineEvent event = new PluginEngineEvent(PluginEngineEventType.PLUGIN_ENABLED, this);
        event.setPayload(plugin);
        this.firePluginEngineEvent(event);
        this.unresolvedPlugins.add(plugin);
        if (this.engineStarted) {
            this.resolvePlugins();
        }
    }

    public synchronized void unloadPlugin(Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("Invalid argument: plugin");
        }
        if (!plugin.isLoaded()) {
            return;
        }
        String pluginUID = plugin.getUID();
        List<Plugin> pluginList = this.plugins.get(pluginUID);
        if (pluginList == null || !pluginList.contains(plugin)) {
            throw new IllegalArgumentException("Plugin is not loaded: " + plugin);
        }
        this.getLogger().log(LoggerLevel.FINE, "Unloading Plugin: " + plugin, null);
        this.unresolvePlugin(plugin, false);
        this.unresolvedPlugins.remove(plugin);
        this.unloadedPlugins.add(plugin);
        pluginList.remove(plugin);
        if (pluginList.isEmpty()) {
            this.plugins.remove(pluginUID);
        }
        plugin.isLoaded = false;
        PluginEngineEvent engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_UNLOADED, this);
        engineEvent.setPayload(plugin);
        this.firePluginEngineEvent(engineEvent);
        engineEvent = null;
        System.gc();
        System.gc();
    }

    public Plugin getUnloadedPlugin(String pluginUID) {
        if (pluginUID == null) {
            return null;
        }
        if (this.getPlugin(pluginUID) != null) {
            return null;
        }
        for (Plugin plugin : this.unloadedPlugins) {
            if (!plugin.getUID().equals(pluginUID)) continue;
            return plugin;
        }
        return null;
    }

    public Plugin getPlugin(String pluginUID) {
        if (pluginUID == null) {
            return null;
        }
        List<Plugin> pluginList = this.plugins.get(pluginUID);
        if (pluginList == null) {
            return null;
        }
        return pluginList.get(0);
    }

    public Plugin getPlugin(String pluginUID, PluginVersion requiredVersion) {
        if (requiredVersion == null) {
            throw new NullPointerException("Invalid argument: requiredVersion");
        }
        if (pluginUID == null) {
            return null;
        }
        List<Plugin> pluginList = this.plugins.get(pluginUID);
        if (pluginList == null) {
            return null;
        }
        for (Plugin plugin : pluginList) {
            if (plugin.getVersion().compareTo(requiredVersion) != 0) continue;
            return plugin;
        }
        return null;
    }

    public Plugin getPlugin(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("Invalid argument: dependency");
        }
        if (dependency.requiredVersion != null) {
            return this.getPlugin(dependency.resolveToPluginUID, dependency.requiredVersion);
        }
        return this.getPlugin(dependency.resolveToPluginUID);
    }

    public Plugin getPlugin(URL url) {
        if (url == null) {
            throw new NullPointerException("Invalid argument: url");
        }
        for (Plugin plugin : this.getPlugins()) {
            if (!plugin.getPluginURL().equals(url)) continue;
            return plugin;
        }
        return null;
    }

    public List<Plugin> getPlugins() {
        ArrayList<Plugin> allPlugins = new ArrayList<Plugin>(this.plugins.size());
        for (List<Plugin> pluginList : this.plugins.values()) {
            allPlugins.addAll(pluginList);
        }
        return allPlugins;
    }

    public List<Plugin> getUnresolvedPlugins() {
        return Collections.unmodifiableList(this.unresolvedPlugins);
    }

    public List<Plugin> getResolvedPlugins() {
        List<Plugin> resolvedPlugins = this.getPlugins();
        resolvedPlugins.removeAll(this.getUnresolvedPlugins());
        return Collections.unmodifiableList(resolvedPlugins);
    }

    public List<Plugin> getUnloadedPlugins() {
        return Collections.unmodifiableList(this.unloadedPlugins);
    }

    public List<Plugin> getLoadedPlugins() {
        List<Plugin> loadedPlugins = this.getPlugins();
        loadedPlugins.remove(this.getUnloadedPlugins());
        return Collections.unmodifiableList(loadedPlugins);
    }

    public boolean isLoaded(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return !this.getUnloadedPlugins().contains(plugin);
    }

    public boolean isEnabled(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return !this.getUnresolvedPlugins().contains(plugin);
    }

    public boolean isLoaded(String pluginUID) {
        Plugin plugin = this.getPlugin(pluginUID);
        if (plugin == null) {
            return false;
        }
        return !this.getUnloadedPlugins().contains(plugin);
    }

    public boolean isEnabled(String pluginUID) {
        Plugin plugin = this.getPlugin(pluginUID);
        if (plugin == null) {
            return false;
        }
        return !this.getUnresolvedPlugins().contains(plugin);
    }

    public void addArchiveExtension(String archiveExtension) {
        if (archiveExtension == null) {
            throw new NullPointerException("Invalid argument: archiveExtension");
        }
        if (!archiveExtension.startsWith(".")) {
            archiveExtension = '.' + archiveExtension;
        }
        this.archiveExtensions.add(archiveExtension.toLowerCase());
    }

    public List<String> getArchiveExtensions() {
        if (this.archiveExtensions.isEmpty()) {
            this.getLogger().log(LoggerLevel.FINE, "No archive extensions specified. Using the defaults \".jar\" and \".par\".", null);
            this.addArchiveExtension(".jar");
            this.addArchiveExtension(".par");
        }
        return new ArrayList<String>(this.archiveExtensions);
    }

    public String getToken(String key) {
        if (key == null) {
            throw new NullPointerException("Invalid argument: key");
        }
        return this.tokens.get(key.toLowerCase());
    }

    public void addToken(String key, String token) {
        if (key == null) {
            throw new NullPointerException("Invalid argument: key");
        }
        this.tokens.put(key.toLowerCase(), token);
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public String getUID() {
        return this.uid;
    }

    public void addPluginEngineListener(IPluginEngineListener listener) {
        if (listener == null) {
            throw new NullPointerException("Invalid argument: listener");
        }
        this.pluginEngineListeners.add(listener);
    }

    public void removePluginEngineListener(IPluginEngineListener listener) {
        if (listener == null) {
            throw new NullPointerException("Invalid argument: listener");
        }
        this.pluginEngineListeners.remove(listener);
    }

    void firePluginEngineEvent(PluginEngineEvent event) {
        for (IPluginEngineListener listener : this.pluginEngineListeners) {
            listener.handlePluginEngineEvent(event);
        }
    }

    public void setTempDirectory(String tempDirectory) {
        if (tempDirectory == null) {
            throw new NullPointerException("Invalid argument: tempDirectory");
        }
        this.tempDirectory = tempDirectory;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public IPluginConfiguration getPluginConfiguration() {
        return this.configuration;
    }

    public void setStartPluginThreadCount(int startPluginThreadCount) {
        if (startPluginThreadCount < 0) {
            throw new IndexOutOfBoundsException("Invalid argument: startPluginThreadCount");
        }
        this.startPluginThreadCount = startPluginThreadCount;
    }

    public void setPluginValidationEnabled(boolean isValidationEnabled) {
        PluginXmlParser.isValidationEnabled = isValidationEnabled;
    }

    public static Plugin getPlugin(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("Invalid argument: classLoader");
        }
        if (classLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)classLoader).getPlugin();
        }
        if (classLoader instanceof ExtensionClassLoader) {
            return ((ExtensionClassLoader)classLoader).extension.getPlugin();
        }
        return null;
    }

    public static Plugin getPlugin(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Invalid argument: clazz");
        }
        return PluginEngine.getPlugin(clazz.getClassLoader());
    }
}

