/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.util.HashMap;
import java.util.Map;
import org.platonos.pluginengine.ExtensionClassLoader;
import org.platonos.pluginengine.ExtensionPoint;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginXmlNode;
import org.platonos.pluginengine.logging.LoggerLevel;

public class Extension {
    private final Plugin plugin;
    private final String extensionPointPluginUID;
    private final String extensionPointName;
    private final String extensionClassName;
    private ExtensionPoint resolvedToExtensionPoint;
    private Object extensionInstance;
    private PluginXmlNode extensionXmlNode;
    private String extensionXml;
    private Map<String, Object> singleClassInstances;
    ExtensionClassLoader extensionClassLoader;

    public Extension(Plugin plugin, String extensionPointPluginUID, String extensionPointName) {
        this(plugin, extensionPointPluginUID, extensionPointName, null);
    }

    public Extension(Plugin plugin, String extensionPointPluginUID, String extensionPointName, String extensionClassName) {
        if (extensionPointPluginUID == null || extensionPointPluginUID.length() == 0) {
            throw new IllegalArgumentException("Invalid argument: extensionPointPluginUID");
        }
        if (extensionPointName == null || extensionPointName.length() == 0) {
            throw new IllegalArgumentException("Invalid argument: extensionPointName");
        }
        this.plugin = plugin;
        this.extensionPointPluginUID = extensionPointPluginUID;
        this.extensionPointName = extensionPointName;
        this.extensionClassName = extensionClassName;
        this.extensionClassLoader = new ExtensionClassLoader(this);
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public Class<?> getExtensionClass() {
        if (this.extensionClassName == null) {
            return null;
        }
        try {
            return this.plugin.pluginClassloader.loadClass(this.extensionClassName);
        }
        catch (ClassNotFoundException ex) {
            this.getPluginEngine().getLogger().log(LoggerLevel.WARNING, "Extension class from Plugin \"" + this.getPlugin() + "\" for ExtensionPoint \"" + this.extensionPointPluginUID + ", " + this.extensionPointName + "\" was not found.", null);
            return null;
        }
    }

    public synchronized Object getExtensionInstance() {
        if (this.resolvedToExtensionPoint == null) {
            return null;
        }
        if (this.extensionInstance != null) {
            return this.extensionInstance;
        }
        Class<?> extensionClass = this.getExtensionClass();
        if (!this.resolvedToExtensionPoint.isExtensionClassCompatible(extensionClass)) {
            if (extensionClass == null) {
                this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Required extension class from Plugin \"" + this.getPlugin() + "\" for ExtensionPoint \"" + this.extensionPointPluginUID + ", " + this.extensionPointName + "\" was not found.", null);
            } else {
                this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Extension class from Plugin \"" + this.getPlugin() + "\" for ExtensionPoint \"" + this.extensionPointPluginUID + ", " + this.extensionPointName + "\" does not implement ExtensionPoint interface: " + this.resolvedToExtensionPoint.getInterfaceClassName(), null);
            }
            return null;
        }
        if (extensionClass == null) {
            return null;
        }
        try {
            this.extensionInstance = extensionClass.newInstance();
        }
        catch (InstantiationException ex) {
            this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Could not instantiate extension class: " + this.getExtensionClassName(), ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Could not instantiate extension class: " + this.getExtensionClassName(), ex);
            return null;
        }
        return this.extensionInstance;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public PluginEngine getPluginEngine() {
        return this.plugin.getPluginEngine();
    }

    public ExtensionPoint getExtensionPoint() {
        return this.resolvedToExtensionPoint;
    }

    void resolve(ExtensionPoint resolvedToExtensionPoint) {
        if (this.resolvedToExtensionPoint != null) {
            throw new IllegalStateException("Extension is already resolved to an ExtensionPoint.");
        }
        this.resolvedToExtensionPoint = resolvedToExtensionPoint;
        resolvedToExtensionPoint.addResolvedExtension(this);
        resolvedToExtensionPoint.getPlugin().extensionResolved(this);
    }

    void unresolve() {
        if (this.resolvedToExtensionPoint == null) {
            throw new IllegalStateException("Extension is not resolved to an ExtensionPoint.");
        }
        this.resolvedToExtensionPoint.getPlugin().extensionUnresolved(this);
        this.resolvedToExtensionPoint.removeResolvedExtension(this);
        this.resolvedToExtensionPoint = null;
        this.extensionInstance = null;
        this.extensionClassLoader = new ExtensionClassLoader(this);
    }

    public String getExtensionXml() {
        return this.extensionXml;
    }

    public PluginXmlNode getExtensionXmlNode() {
        return this.extensionXmlNode;
    }

    public void setExtensionXmlNode(PluginXmlNode extensionXmlNode) {
        if (extensionXmlNode == null) {
            throw new NullPointerException("Invalid argument: extensionXmlNode");
        }
        this.extensionXmlNode = extensionXmlNode;
        this.extensionXml = extensionXmlNode.toXML();
    }

    public String getExtensionPointPluginUID() {
        return this.extensionPointPluginUID;
    }

    public String getExtensionPointName() {
        return this.extensionPointName;
    }

    public Object getNewInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(className, true, this.getPlugin().pluginClassloader);
        return clazz.newInstance();
    }

    public Object getSingleInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object instance;
        if (this.singleClassInstances == null) {
            this.singleClassInstances = new HashMap<String, Object>(8);
        }
        if ((instance = this.singleClassInstances.get(className)) == null) {
            instance = this.getNewInstance(className);
            this.singleClassInstances.put(className, instance);
        }
        return instance;
    }

    public String toString() {
        return "Plugin: " + this.plugin.getUID() + ", ExtensionPoint: " + this.extensionPointPluginUID + ", " + this.extensionPointName;
    }
}

