/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.logging.LoggerLevel;
import org.platonos.pluginengine.version.PluginVersion;

public class Dependency {
    private final Plugin dependentPlugin;
    final String resolveToPluginUID;
    PluginVersion requiredVersion;
    private boolean isOptional = false;
    private Plugin resolvedToPlugin;

    public Dependency(Plugin dependentPlugin, String resolveToPluginUID) {
        if (dependentPlugin == null) {
            throw new NullPointerException("Invalid argument: dependentPlugin");
        }
        if (resolveToPluginUID == null) {
            throw new NullPointerException("Invalid argument: resolveToPluginUID");
        }
        this.dependentPlugin = dependentPlugin;
        this.resolveToPluginUID = resolveToPluginUID;
    }

    public Dependency(Plugin dependentPlugin, String resolveToPluginUID, PluginVersion requiredVersion) {
        this(dependentPlugin, resolveToPluginUID);
        if (requiredVersion == null) {
            throw new NullPointerException("Invalid argument: requiredVersion");
        }
        this.requiredVersion = requiredVersion;
    }

    public Plugin getDependentPlugin() {
        return this.dependentPlugin;
    }

    public Plugin getResolvedToPlugin() {
        return this.resolvedToPlugin;
    }

    public String getResolveToPluginUID() {
        return this.resolveToPluginUID;
    }

    public boolean isResolved() {
        return this.resolvedToPlugin != null;
    }

    public PluginVersion getRequiredVersion() {
        return this.requiredVersion;
    }

    public synchronized void setOptional(boolean isOptional) {
        if (this.dependentPlugin != null && this.isOptional && !isOptional && this.resolvedToPlugin == null && this.dependentPlugin.isResolved()) {
            this.dependentPlugin.getPluginEngine().getLogger().log(LoggerLevel.FINE, "Unresolving Plugin because an unresolved optional Dependency was changed to required: " + this.dependentPlugin, null);
            this.dependentPlugin.getPluginEngine().unresolvePlugin(this.dependentPlugin, true);
        }
        this.isOptional = isOptional;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    void resolve(Plugin resolvedToPlugin) {
        this.resolvedToPlugin = resolvedToPlugin;
        resolvedToPlugin.dependentPluginResolved(this.dependentPlugin);
    }

    void unresolve() {
        this.resolvedToPlugin.dependentPluginUnresolved(this.dependentPlugin);
        this.resolvedToPlugin = null;
    }

    public boolean isCompatible(Plugin plugin) {
        return this.resolveToPluginUID.equals(plugin.getUID()) && this.isVersionCompatible(plugin.getVersion());
    }

    boolean isVersionCompatible(PluginVersion dependentPluginVersion) {
        if (dependentPluginVersion == null) {
            throw new NullPointerException("Invalid argument: dependentPluginVersion");
        }
        if (this.requiredVersion != null) {
            return dependentPluginVersion.compareTo(this.requiredVersion) == 0;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("dependentPlugin: ");
        buffer.append(this.dependentPlugin);
        buffer.append(", resolveToPluginUID: ");
        buffer.append(this.resolveToPluginUID);
        if (this.requiredVersion != null) {
            buffer.append(", requiredVersion: ");
            buffer.append(this.requiredVersion);
        }
        return buffer.toString();
    }
}

