/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.repository.info;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class InstallInfo {
    private static final String PROPERTY_VERSION = "version";
    private static final String INSTALL_INFO_FILE = "install.info";
    private static final String PROPERTY_FILE = "file";
    private static final String PROPERTY_UPDATEPLUGIN = "updateplugin";
    private static final String PROPERTY_MD5 = "md5";
    public final String file;
    public final String updatePlugin;
    public final String version;
    public final String md5;

    public InstallInfo(String file, String updatePlugin, String version, String md5) {
        this.file = file;
        this.updatePlugin = updatePlugin;
        this.version = version;
        this.md5 = md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallInfo(File dir) throws IOException {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(dir, INSTALL_INFO_FILE));
            properties.load(fis);
            this.file = properties.getProperty(PROPERTY_FILE);
            this.updatePlugin = properties.getProperty(PROPERTY_UPDATEPLUGIN);
            this.version = properties.getProperty(PROPERTY_VERSION);
            this.md5 = properties.getProperty(PROPERTY_MD5);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File dir) throws IOException {
        Properties properties = new Properties();
        OutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(dir, INSTALL_INFO_FILE));
            if (this.file != null) {
                properties.setProperty(PROPERTY_FILE, this.file);
            }
            if (this.updatePlugin != null) {
                properties.setProperty(PROPERTY_UPDATEPLUGIN, this.updatePlugin);
            }
            if (this.version != null) {
                properties.setProperty(PROPERTY_VERSION, this.version);
            }
            if (this.md5 != null) {
                properties.setProperty(PROPERTY_MD5, this.md5);
            }
            properties.store(fos, null);
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

