/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.repository.info;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.platonos.pluginengine.PluginEngineException;
import org.platonos.pluginengine.version.PluginVersion;

public final class DependencyInfo {
    private static final String TEXT_PLUGIN_PATTERN = String.format("^(\\p{Alnum}|_|-)+(\\.(\\p{Alnum}|_|-)+)*\\p{Space}*(\\[(%s|%s|%s|%s)\\])?$", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+)?)?", PluginVersion.TEXT_INTERVAL_VERSION_PATTERN, "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+-?|-)?|-)?", "\\p{Digit}+(\\.\\p{Digit}+(\\.\\p{Digit}+|\\+?||\\+)?|\\+)?");
    private static final Pattern PLUGIN_PATTERN = Pattern.compile(TEXT_PLUGIN_PATTERN);
    private final String plugin;
    private final String uid;
    private final String version;
    private final String exactVersion;
    private final String minVersion;
    private final String maxVersion;
    private final PluginVersion dependencyVersion;

    public DependencyInfo(String plugin) throws IllegalArgumentException {
        if (PLUGIN_PATTERN.matcher(plugin).matches()) {
            Matcher matcher;
            this.plugin = plugin;
            this.uid = plugin.substring(0, plugin.indexOf(91));
            this.version = plugin.substring(plugin.indexOf(91) + 1, plugin.length() - 1);
            try {
                this.dependencyVersion = PluginVersion.createDependencyVersion(this.version);
            }
            catch (PluginEngineException e) {
                throw new IllegalArgumentException("Illegal dependency version: " + this.version, e);
            }
            this.exactVersion = PluginVersion.VERSION_PATTERN.matcher(this.version).matches() ? ((matcher = PluginVersion.VERSION_PATTERN.matcher(this.version)).find() ? matcher.group() : null) : null;
            if (PluginVersion.INTERVAL_VERSION_PATTERN.matcher(this.version).matches()) {
                matcher = PluginVersion.VERSION_PATTERN.matcher(this.version);
                this.minVersion = matcher.find() ? matcher.group() : null;
                this.maxVersion = matcher.find() ? matcher.group() : null;
            } else if (PluginVersion.MIN_VERSION_PATTERN.matcher(this.version).matches()) {
                matcher = PluginVersion.VERSION_PATTERN.matcher(this.version);
                this.minVersion = matcher.find() ? matcher.group() : null;
                this.maxVersion = null;
            } else {
                this.minVersion = null;
                this.maxVersion = PluginVersion.MAX_VERSION_PATTERN.matcher(this.version).matches() ? ((matcher = PluginVersion.VERSION_PATTERN.matcher(this.version)).find() ? matcher.group() : null) : null;
            }
        } else {
            throw new IllegalArgumentException(plugin);
        }
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getUid() {
        return this.uid;
    }

    public String getExactVersion() {
        return this.exactVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public PluginVersion getDependencyVersion() {
        return this.dependencyVersion;
    }

    public String toString() {
        return this.plugin;
    }
}

