/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.repository;

import es.uvigo.ei.aibench.repository.Inflater;
import es.uvigo.ei.aibench.repository.info.InstallInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PluginInstaller {
    private static final Logger logger = Logger.getLogger(PluginInstaller.class);
    private static final String INSTALL_FILE_FORMAT = ".%s.install";
    private static final String OLD_FILE_FORMAT = ".%s.old";
    private static final String DEFAULT_INFO_FILE = "plugins.dat";
    private static final int BUFFER_SIZE = 8192;
    private final String[] ignoreDirs;
    private final File pluginsDir;
    private final File installDir;
    private final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                if (PluginInstaller.this.ignoreDirs != null) {
                    for (String ignore : PluginInstaller.this.ignoreDirs) {
                        if (!ignore.equals(pathname.getName())) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    };

    public PluginInstaller(String pluginsDir, String installDir) throws IllegalArgumentException {
        this(pluginsDir, installDir, null);
    }

    public PluginInstaller(String pluginsDir, String installDir, String[] ignoreDirs) throws IllegalArgumentException {
        this.pluginsDir = new File(pluginsDir);
        this.installDir = new File(installDir);
        this.ignoreDirs = ignoreDirs;
        if (!this.pluginsDir.isDirectory() && !this.pluginsDir.mkdir()) {
            throw new IllegalArgumentException(String.format("File '%s' isn't a directory.", pluginsDir));
        }
        if (!this.installDir.isDirectory() && !this.installDir.mkdir()) {
            throw new IllegalArgumentException(String.format("File '%s' isn't a directory.", installDir));
        }
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public List<String> getInstallUIDs() {
        File[] files = this.installDir.listFiles(this.directoryFilter);
        ArrayList<String> uids = new ArrayList<String>(files.length);
        for (File file : files) {
            uids.add(file.getName());
        }
        return uids;
    }

    public List<String> getValidInstallUIDs() {
        File[] files = this.installDir.listFiles(this.directoryFilter);
        ArrayList<String> uids = new ArrayList<String>(files.length);
        for (File file : files) {
            if (!this.isValidInstall(file.getName())) continue;
            uids.add(file.getName());
        }
        return uids;
    }

    public InstallInfo getInstallInfo(String uid) {
        if (this.isValidInstall(uid)) {
            try {
                return new InstallInfo(new File(new File(uid), DEFAULT_INFO_FILE));
            }
            catch (IOException e) {
                logger.error("Error retrieving plugin install information: " + uid, e);
            }
        }
        return null;
    }

    public boolean isValidInstall(String uid) {
        File updateDir = new File(this.installDir, uid);
        if (updateDir.exists() && updateDir.isDirectory()) {
            try {
                InstallInfo info = new InstallInfo(updateDir);
                if (info.file == null) {
                    return false;
                }
                if (!Inflater.inflatableFile(info.file)) {
                    return false;
                }
                File pluginFile = new File(updateDir, info.file);
                if (!pluginFile.exists()) {
                    return false;
                }
                if (info.md5 == null) {
                    return true;
                }
                return PluginInstaller.checkMD5(info.md5, pluginFile);
            }
            catch (IOException e) {
                logger.error("Error validating install files: " + uid, e);
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Error validating md5 checksum for plugin install files: " + uid, e);
                return false;
            }
        }
        return false;
    }

    public boolean deleteInstall(String uid) {
        logger.info("Deleting install files: " + uid);
        File file = new File(this.installDir, uid);
        if (file.exists() && file.isDirectory() && PluginInstaller.deleteFile(file)) {
            logger.info("Install files deleted: " + uid);
            return true;
        }
        logger.warn("Install files could not be deleted: " + uid);
        return false;
    }

    public void clearInvalidInstalls() {
        for (File file : this.installDir.listFiles(this.directoryFilter)) {
            if (this.isValidInstall(file.getName())) continue;
            PluginInstaller.deleteFile(file);
        }
    }

    public void installPlugins() {
        this.installPlugins(true);
    }

    public void installPlugins(boolean deleteInvalidUpdates) {
        for (String uid : this.getInstallUIDs()) {
            logger.info("Installing plugin: " + uid);
            if (this.isValidInstall(uid)) {
                try {
                    if (this.installPlugin(uid)) {
                        logger.info("Plugin installed: " + uid);
                        continue;
                    }
                    logger.error("Plugin can't be installed: " + uid);
                    if (!deleteInvalidUpdates) continue;
                    logger.error(String.format("Error installing plugin %s. The plugin install files will be deleted.", uid));
                    this.deleteInstall(uid);
                }
                catch (IOException ioe) {
                    if (deleteInvalidUpdates) {
                        logger.error(String.format("Error installing plugin %s. The plugin install files will be deleted.", uid), ioe);
                        this.deleteInstall(uid);
                        continue;
                    }
                    logger.error("Error installing plugin: " + uid, ioe);
                }
                continue;
            }
            logger.warn("Install files not valid: " + uid);
            if (!deleteInvalidUpdates) continue;
            this.deleteInstall(uid);
        }
    }

    public boolean installPlugin(String uid) throws IOException {
        File uidInstallDir = new File(this.installDir, uid);
        InstallInfo info = new InstallInfo(uidInstallDir);
        if (info.file.endsWith("jar")) {
            File jarFile = new File(uidInstallDir, info.file);
            if (info.updatePlugin == null) {
                if (jarFile.renameTo(new File(this.pluginsDir, info.file))) {
                    PluginInstaller.deleteFile(uidInstallDir);
                    return true;
                }
                return false;
            }
            File updatePluginFile = new File(this.pluginsDir, info.updatePlugin);
            File updatePluginOld = new File(this.pluginsDir, String.format(OLD_FILE_FORMAT, info.updatePlugin));
            if (updatePluginFile.renameTo(updatePluginOld) && jarFile.renameTo(new File(this.pluginsDir, info.file))) {
                PluginInstaller.deleteFile(uidInstallDir);
                PluginInstaller.deleteFile(updatePluginOld);
                return true;
            }
            return false;
        }
        File installFile = new File(uidInstallDir, info.file);
        if (info.updatePlugin == null) {
            File pluginDir = new File(this.pluginsDir, uid);
            File outputDir = new File(this.pluginsDir, String.format(INSTALL_FILE_FORMAT, uid));
            if (Inflater.inflate(installFile, outputDir) && outputDir.renameTo(pluginDir)) {
                PluginInstaller.deleteFile(uidInstallDir);
                return true;
            }
            return false;
        }
        File updatePluginFile = new File(this.pluginsDir, info.updatePlugin);
        File pluginDir = new File(this.pluginsDir, uid);
        File updatePluginOld = new File(this.pluginsDir, String.format(OLD_FILE_FORMAT, info.updatePlugin));
        File outputDir = new File(this.pluginsDir, String.format(INSTALL_FILE_FORMAT, uid));
        if (updatePluginFile.renameTo(updatePluginOld) && Inflater.inflate(installFile, outputDir) && outputDir.renameTo(pluginDir)) {
            PluginInstaller.deleteFile(uidInstallDir);
            PluginInstaller.deleteFile(updatePluginOld);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkMD5(String testMD5, File testFile) throws IOException, NoSuchAlgorithmException {
        BufferedInputStream bis = null;
        try {
            int len;
            if (testMD5 == null) {
                boolean bl = false;
                return bl;
            }
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            bis = new BufferedInputStream(new FileInputStream(testFile), 8192);
            byte[] data = new byte[8192];
            while ((len = bis.read(data)) != -1) {
                md5.update(data, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, md5.digest());
            String testFileMD5 = bigInt.toString(16);
            if (testMD5.equalsIgnoreCase(testFileMD5)) {
                boolean bl = true;
                return bl;
            }
            logger.info(String.format("MD5 test not passed (MD5: %s; File: %s)", testMD5, testFile.getPath()));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            for (File childFile : file.listFiles()) {
                PluginInstaller.deleteFile(childFile);
            }
        }
        return file.delete();
    }
}

