/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.repository;

import es.uvigo.ei.aibench.repository.NotInitializedException;
import es.uvigo.ei.aibench.repository.PluginDownloadEvent;
import es.uvigo.ei.aibench.repository.PluginDownloadInfoEvent;
import es.uvigo.ei.aibench.repository.PluginDownloadListener;
import es.uvigo.ei.aibench.repository.PluginInstaller;
import es.uvigo.ei.aibench.repository.info.PluginInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class PluginDownloader {
    private static final Logger logger = Logger.getLogger(PluginDownloader.class);
    private static final Map<String, Object> DOWNLOAD_LOCKS = new Hashtable<String, Object>();
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_INFO_FILE = "plugins.dat";
    private static int DOWNLOADID_COUNTER = 0;
    private final String host;
    private final String infoFile;
    private final File installDir;
    private final Map<String, PluginInfo> infoPlugins;
    private final Map<Integer, DownloadThread> downloadThreads;
    private final List<PluginDownloadListener> downloadListeners;
    private final ExecutorService notifierThreads;

    public PluginDownloader(String host, String installDir) {
        this(host, DEFAULT_INFO_FILE, installDir);
    }

    public PluginDownloader(String host, String infoFile, String installDir) {
        this.host = host;
        this.infoFile = infoFile;
        this.installDir = new File(installDir);
        this.infoPlugins = new Hashtable<String, PluginInfo>();
        this.downloadThreads = new Hashtable<Integer, DownloadThread>();
        this.downloadListeners = new Vector<PluginDownloadListener>();
        this.notifierThreads = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object getDownloadLock(String directory) {
        if (!DOWNLOAD_LOCKS.containsKey(directory)) {
            Map<String, Object> map = DOWNLOAD_LOCKS;
            synchronized (map) {
                if (!DOWNLOAD_LOCKS.containsKey(directory)) {
                    DOWNLOAD_LOCKS.put(directory, directory);
                }
            }
        }
        return DOWNLOAD_LOCKS.get(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDownloadListener(PluginDownloadListener listener) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            if (this.downloadListeners.contains(listener)) {
                return false;
            }
            return this.downloadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDownloadListener(PluginDownloadListener listener) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            return this.downloadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInfoDownloadStarted(final PluginDownloadInfoEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadInfoStarted(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInfoDownloadFinished(final PluginDownloadInfoEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadInfoFinished(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInfoDownloadError(final PluginDownloadInfoEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadInfoError(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDownloadStarted(final PluginDownloadEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadStarted(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDownloadStep(final PluginDownloadEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadStep(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDownloadError(final PluginDownloadEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadError(event);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDownloadFinished(final PluginDownloadEvent event) {
        List<PluginDownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.notifierThreads.execute(new Runnable(){

                @Override
                public void run() {
                    for (PluginDownloadListener listener : PluginDownloader.this.downloadListeners) {
                        listener.downloadFinished(event);
                    }
                }
            });
        }
    }

    private static final String getPluginFromKey(String key) {
        return key.substring(0, key.lastIndexOf(46));
    }

    private static final String getPropertyFromKey(String key) {
        return key.substring(key.lastIndexOf(46) + 1, key.length());
    }

    private final String getFileURL(String file) {
        return String.format("%s/%s", this.host, file);
    }

    public String getHost() {
        return this.host;
    }

    public String getInfoFile() {
        return this.infoFile;
    }

    public String getInfoFileURL() {
        return this.getFileURL(this.infoFile);
    }

    public synchronized boolean hasInfo() {
        return !this.infoPlugins.isEmpty();
    }

    public synchronized void downloadInfo() throws IOException {
        try {
            this.notifyInfoDownloadStarted(new PluginDownloadInfoEvent(this, this.getInfoFile()));
            HashMap<String, PluginInfo> infos = new HashMap<String, PluginInfo>();
            URL url = new URL(this.getInfoFileURL());
            Properties properties = new Properties();
            properties.load(url.openStream());
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                String keyPlugin = PluginDownloader.getPluginFromKey(keyString);
                String property = PluginDownloader.getPropertyFromKey(keyString);
                String value = properties.getProperty(keyString);
                if (!infos.containsKey(keyPlugin)) {
                    infos.put(keyPlugin, new PluginInfo(keyPlugin, this.getHost()));
                }
                ((PluginInfo)infos.get(keyPlugin)).setValue(property, value);
            }
            this.infoPlugins.clear();
            for (PluginInfo info : infos.values()) {
                if (info.getUID() == null) {
                    logger.warn("Incomplete Plugin Info: " + info);
                    continue;
                }
                this.infoPlugins.put(info.getUID(), info);
            }
            this.notifyInfoDownloadFinished(new PluginDownloadInfoEvent(this, this.getInfoFile()));
        }
        catch (IOException ioe) {
            this.notifyInfoDownloadError(new PluginDownloadInfoEvent(this, this.getInfoFile(), ioe));
            throw ioe;
        }
    }

    public PluginInfo getPluginInfo(String uid) {
        return this.infoPlugins.get(uid);
    }

    public Collection<PluginInfo> getPluginsInfo() {
        return this.infoPlugins.values();
    }

    public void downloadPlugin(String uid) throws NotInitializedException, IllegalArgumentException {
        if (!this.hasInfo()) {
            throw new NotInitializedException();
        }
        PluginInfo info = this.getPluginInfo(uid);
        if (info == null) {
            throw new IllegalArgumentException("There isn't information for the plugin: " + uid);
        }
        this.downloadPlugin(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPlugin(PluginInfo plugin) throws NotInitializedException {
        if (this.hasInfo()) {
            Map<Integer, DownloadThread> map = this.downloadThreads;
            synchronized (map) {
                DownloadThread thread = new DownloadThread(plugin);
                this.downloadThreads.put(thread.getDownloadId(), thread);
                thread.start();
            }
        } else {
            throw new NotInitializedException();
        }
    }

    public void downloadPlugin(String uid, String updatePlugin) throws NotInitializedException, IllegalArgumentException {
        if (!this.hasInfo()) {
            throw new NotInitializedException();
        }
        PluginInfo info = this.getPluginInfo(uid);
        if (info == null) {
            throw new IllegalArgumentException("There isn't information for the plugin: " + uid);
        }
        this.downloadPlugin(info, updatePlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPlugin(PluginInfo plugin, String updatePlugin) throws NotInitializedException {
        if (this.hasInfo()) {
            Map<Integer, DownloadThread> map = this.downloadThreads;
            synchronized (map) {
                DownloadThread thread = new DownloadThread(plugin, updatePlugin);
                this.downloadThreads.put(thread.getDownloadId(), thread);
                thread.start();
            }
        } else {
            throw new NotInitializedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownload(int downloadId) {
        Map<Integer, DownloadThread> map = this.downloadThreads;
        synchronized (map) {
            DownloadThread thread = this.downloadThreads.get(downloadId);
            if (thread != null && thread.isAlive()) {
                thread.stopDownload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownloads() {
        Map<Integer, DownloadThread> map = this.downloadThreads;
        synchronized (map) {
            for (DownloadThread thread : this.downloadThreads.values()) {
                thread.stopDownload();
            }
            this.downloadThreads.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.cancelDownloads();
    }

    public String toString() {
        String toString = "";
        for (String key : this.infoPlugins.keySet()) {
            toString = toString + this.infoPlugins.get(key);
            toString = toString + '\n';
        }
        return toString;
    }

    static /* synthetic */ int access$108() {
        return DOWNLOADID_COUNTER++;
    }

    private class DownloadThread
    extends Thread {
        private final int downloadId = PluginDownloader.access$108();
        private final PluginInfo plugin;
        private final String updatePlugin;
        private final File directory;
        private final Object lock;
        private int total;
        private int downloaded;
        private boolean stopDownload;

        public DownloadThread(PluginInfo plugin) {
            this(plugin, null);
        }

        public DownloadThread(PluginInfo plugin, String updatePlugin) {
            Object lock;
            this.plugin = plugin;
            this.updatePlugin = updatePlugin;
            this.directory = new File(PluginDownloader.this.installDir, plugin.getUID());
            this.total = 0;
            this.downloaded = 0;
            this.stopDownload = false;
            try {
                lock = PluginDownloader.getDownloadLock(this.directory.getCanonicalPath());
            }
            catch (IOException ioe) {
                logger.warn("Canonical Path couldn't be used. Using Absolute Path: " + this.directory.getAbsolutePath());
                lock = PluginDownloader.getDownloadLock(this.directory.getAbsolutePath());
            }
            this.lock = lock;
        }

        public final int getDownloadId() {
            return this.downloadId;
        }

        public void stopDownload() {
            this.stopDownload = true;
        }

        private void notifyDownloadStarted() {
            PluginDownloader.this.notifyDownloadStarted(new PluginDownloadEvent(PluginDownloader.this, this.downloadId, this.plugin, this.total, this.downloaded));
        }

        private void notifyDownloadStep() {
            PluginDownloader.this.notifyDownloadStep(new PluginDownloadEvent(PluginDownloader.this, this.downloadId, this.plugin, this.total, this.downloaded));
        }

        private void notifyDownloadFinished() {
            PluginDownloader.this.notifyDownloadFinished(new PluginDownloadEvent(PluginDownloader.this, this.downloadId, this.plugin, this.total, this.downloaded));
        }

        private void notifyDownloadError(IOException error) {
            PluginDownloader.this.notifyDownloadError(new PluginDownloadEvent(PluginDownloader.this, this.downloadId, this.plugin, this.total, this.downloaded, error));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            OutputStream fos = null;
            this.downloaded = 0;
            this.total = 0;
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (!this.stopDownload && this.directory.mkdir()) {
                        int len;
                        File installFile = new File(this.directory, this.plugin.getFile());
                        URL url = new URL(PluginDownloader.this.getFileURL(this.plugin.getFile()));
                        URLConnection connection = url.openConnection();
                        is = connection.getInputStream();
                        fos = new FileOutputStream(installFile);
                        this.total = connection.getContentLength() + 1;
                        this.notifyDownloadStarted();
                        byte[] data = new byte[8192];
                        while (!this.stopDownload && (len = is.read(data)) != -1) {
                            ((FileOutputStream)fos).write(data, 0, len);
                            this.downloaded += len;
                            this.notifyDownloadStep();
                        }
                        if (!this.stopDownload) {
                            if (this.updatePlugin == null) {
                                this.plugin.getInstallInfo().store(this.directory);
                            } else {
                                this.plugin.getInstallInfo(this.updatePlugin).store(this.directory);
                            }
                            ++this.downloaded;
                        }
                        this.notifyDownloadFinished();
                    }
                }
                catch (IOException ioe) {
                    this.stopDownload = true;
                    this.notifyDownloadError(ioe);
                }
                finally {
                    PluginDownloader.this.downloadThreads.remove(this.downloadId);
                    try {
                        if (fos != null) {
                            fos.flush();
                            ((FileOutputStream)fos).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (this.stopDownload) {
                        PluginInstaller.deleteFile(this.directory);
                    }
                }
            }
        }
    }
}

