/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.repository;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Inflater {
    private static final int BUFFER_SIZE = 8192;

    public static boolean inflate(File source, File output) {
        boolean done = true;
        if (Inflater.inflatableFile(source)) {
            String sourceName = source.getName();
            try {
                if (sourceName.endsWith("jar")) {
                    Inflater.copyFile(source, output);
                } else if (sourceName.endsWith("zip")) {
                    done = Inflater.inflateZip(source, output);
                } else if (sourceName.endsWith("tar.gz")) {
                    done = Inflater.inflateTarGz(source, output);
                } else if (sourceName.endsWith("tar")) {
                    done = Inflater.inflateTar(source, output);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                done = false;
            }
        } else {
            done = false;
        }
        return done;
    }

    public static boolean inflatableFile(File source) {
        return Inflater.inflatableFile(source.getName());
    }

    public static boolean inflatableFile(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip") || fileName.endsWith(".tar.gz") || fileName.endsWith(".tar");
    }

    private static void copyFile(File source, File output) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(output).getChannel();
            ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)outputChannel));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                sourceChannel.close();
            }
            catch (IOException iOException) {}
            try {
                outputChannel.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean inflateZip(File source, File output) throws IOException {
        if (output.mkdir()) {
            ZipInputStream zis = null;
            BufferedOutputStream bos = null;
            try {
                ZipEntry entry;
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(source), 8192));
                byte[] data = new byte[8192];
                while ((entry = zis.getNextEntry()) != null) {
                    int len;
                    File file = new File(output, entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(file), 8192);
                    while ((len = zis.read(data)) != -1) {
                        bos.write(data, 0, len);
                    }
                    bos.flush();
                    bos.close();
                    bos = null;
                }
                zis.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                try {
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return false;
    }

    private static boolean inflateTarGz(File source, File output) throws IOException {
        if (output.mkdir()) {
            BufferedOutputStream bos = null;
            TarInputStream tis = null;
            try {
                TarEntry entry;
                byte[] data = new byte[8192];
                tis = new TarInputStream(new GZIPInputStream((InputStream)new FileInputStream(source), 8192), 8192);
                while ((entry = tis.getNextEntry()) != null) {
                    int len;
                    File file = new File(output, entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    while ((len = tis.read(data)) != -1) {
                        bos.write(data, 0, len);
                    }
                    bos.flush();
                    bos.close();
                    bos = null;
                }
                tis.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (tis != null) {
                        tis.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return false;
    }

    private static boolean inflateTar(File source, File output) throws IOException {
        if (output.mkdir()) {
            BufferedOutputStream bos = null;
            TarInputStream tis = null;
            try {
                TarEntry entry;
                byte[] data = new byte[8192];
                tis = new TarInputStream(new FileInputStream(source), 8192);
                while ((entry = tis.getNextEntry()) != null) {
                    int len;
                    File file = new File(output, entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    while ((len = tis.read(data)) != -1) {
                        bos.write(data, 0, len);
                    }
                    bos.flush();
                    bos.close();
                    bos = null;
                }
                tis.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (tis != null) {
                        tis.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return false;
    }
}

