/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.operations;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScaleElementData {
    public static List<ElementData> scale(DoubleFunction<Double> scale, List<ElementData> toScale) {
        return toScale.stream().map(data -> ScaleElementData.scale(scale, data)).collect(Collectors.toList());
    }

    public static ElementData[] scale(DoubleFunction<Double> scale, ElementData ... toScale) {
        return (ElementData[])Stream.of(toScale).map(data -> ScaleElementData.scale(scale, data)).toArray(ElementData[]::new);
    }

    public static ElementData scale(DoubleFunction<Double> scale, ElementData toScale) {
        LineData[] scaled = new LineData[toScale.getNumLines()];
        for (int i = 0; i < toScale.getNumLines(); ++i) {
            LineData lDtoScale = toScale.getLines()[i];
            double[] scaledValues = ScaleElementData.scale(lDtoScale.getData(), scale);
            scaled[i] = new LineData(lDtoScale.getName(), scaledValues, lDtoScale.getCoordinates());
        }
        return ElementData.createElementData(toScale.getName(), scaled);
    }

    private static final double[] scale(double[] data, DoubleFunction<Double> scale) {
        double[] scaled = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            scaled[i] = scale.apply(data[i]);
        }
        return scaled;
    }
}

