/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.operations;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NormalizeElementData {
    public static List<ElementData> normalize(ElementData standard, List<ElementData> toNormalize) {
        return toNormalize.stream().map(data -> NormalizeElementData.normalize(standard, data)).collect(Collectors.toList());
    }

    public static ElementData[] normalize(ElementData standard, ElementData ... toNormalize) {
        return (ElementData[])Stream.of(toNormalize).map(data -> NormalizeElementData.normalize(standard, data)).toArray(ElementData[]::new);
    }

    public static ElementData normalize(ElementData standard, ElementData toNormalize) {
        if (!toNormalize.isCompatibleWith(standard)) {
            throw new IllegalArgumentException("standard and toNormalize are not compatible");
        }
        LineData[] normalized = new LineData[toNormalize.getNumLines()];
        for (int i = 0; i < toNormalize.getNumLines(); ++i) {
            LineData lDtoNormalize = toNormalize.getLines()[i];
            LineData lDStandard = standard.getLines()[i];
            double[] normalizedValues = NormalizeElementData.normalize(lDtoNormalize.getData(), lDStandard.getData());
            normalized[i] = new LineData(lDtoNormalize.getName(), normalizedValues, lDtoNormalize.getCoordinates());
        }
        return ElementData.createElementData(toNormalize.getName(), normalized);
    }

    private static final double[] normalize(double[] data, double[] standard) {
        double[] normalized = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            normalized[i] = data[i] / standard[i];
        }
        return normalized;
    }

    public static ElementData normalize(ElementData toNormalize) {
        LineData[] normalized = new LineData[toNormalize.getNumLines()];
        for (int i = 0; i < toNormalize.getNumLines(); ++i) {
            LineData lDtoNormalize = toNormalize.getLines()[i];
            double maxValue = toNormalize.getMaxValue();
            double[] normalizedValues = NormalizeElementData.normalize(lDtoNormalize.getData(), maxValue);
            normalized[i] = new LineData(lDtoNormalize.getName(), normalizedValues, lDtoNormalize.getCoordinates());
        }
        ElementData createElementData = ElementData.createElementData(toNormalize.getName(), normalized);
        return createElementData;
    }

    private static final double[] normalize(double[] data, double value) {
        double[] normalized = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            normalized[i] = data[i] / value;
        }
        return normalized;
    }
}

