/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.operations;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.HorizontalLineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.VerticalLineCoordinates;
import es.uvigo.ei.sing.laimages.core.operations.BilinearInterpolator;
import java.util.List;
import java.util.function.IntBinaryOperator;
import java.util.stream.IntStream;
import org.apache.commons.math3.analysis.BivariateFunction;

public class Interpolator {
    private static final IntBinaryOperator CALCULATE_SIZE = (actual, level) -> actual + (actual - 1) * level;

    public static ElementData interpolate(ElementData data, int interpolationLevel) {
        if (interpolationLevel == 0) {
            return data;
        }
        double[][] newValues = Interpolator.calculateNewValues(data.getData(0.0), interpolationLevel);
        LineData[] newLines = Interpolator.calculateNewLines(data, interpolationLevel, newValues);
        return ElementData.createElementData(data.getName(), newLines);
    }

    private static double[][] calculateNewValues(double[][] data, int interpolationLevel) {
        int initialRows = data.length;
        int initialColumns = data[0].length;
        BilinearInterpolator interpolator = new BilinearInterpolator();
        BivariateFunction function = interpolator.interpolate(IntStream.range(0, initialRows).asDoubleStream().toArray(), IntStream.range(0, initialColumns).asDoubleStream().toArray(), data);
        int newNumRows = CALCULATE_SIZE.applyAsInt(initialRows, interpolationLevel);
        int newNumColumns = CALCULATE_SIZE.applyAsInt(initialColumns, interpolationLevel);
        double[][] newValues = new double[newNumRows][newNumColumns];
        double xFactor = ((double)initialRows - 1.0) / ((double)newNumRows - 1.0);
        double yFactor = ((double)initialColumns - 1.0) / ((double)newNumColumns - 1.0);
        for (int i = 0; i < newValues.length; ++i) {
            for (int j = 0; j < newValues[i].length; ++j) {
                newValues[i][j] = function.value((double)i * xFactor, (double)j * yFactor);
            }
        }
        return newValues;
    }

    private static LineData[] calculateNewLines(ElementData data, int interpolationLevel, double[][] newValues) {
        boolean isVertical = data.getCoordinates()[0].isVertical();
        int newLineCount = isVertical ? newValues[0].length : newValues.length;
        LineData[] newLines = new LineData[newLineCount];
        List<Double> xAxis = data.getXAxis();
        List<Double> yAxis = data.getYAxis();
        double minX = xAxis.stream().mapToDouble(Double::valueOf).min().orElseThrow(IllegalStateException::new);
        double maxX = xAxis.stream().mapToDouble(Double::valueOf).max().orElseThrow(IllegalStateException::new);
        double minY = yAxis.stream().mapToDouble(Double::valueOf).min().orElseThrow(IllegalStateException::new);
        double maxY = yAxis.stream().mapToDouble(Double::valueOf).max().orElseThrow(IllegalStateException::new);
        double tickX = (maxX - minX) / (double)(newValues[0].length - 1);
        double tickY = (maxY - minY) / (double)(newValues.length - 1);
        for (int i = 0; i < newLineCount; ++i) {
            double[] lineValues = Interpolator.getLineValues(newValues, i, isVertical);
            int minNumIndex = Interpolator.firstValueIndex(lineValues);
            int maxNumIndex = Interpolator.lastValueIndex(lineValues);
            double[] nonNanLineValues = new double[maxNumIndex - minNumIndex + 1];
            System.arraycopy(lineValues, minNumIndex, nonNanLineValues, 0, nonNanLineValues.length);
            newLines[i] = new LineData("Line " + (i + 1), nonNanLineValues, isVertical ? new VerticalLineCoordinates(tickY, minY + (double)minNumIndex * tickY, minY + (double)maxNumIndex * tickY, tickX * (double)i + minX) : new HorizontalLineCoordinates(tickX, minX + (double)minNumIndex * tickX, minX + (double)maxNumIndex * tickX, tickY * (double)i + minY));
        }
        return newLines;
    }

    private static double[] getLineValues(double[][] values, int index, boolean vertical) {
        if (vertical) {
            double[] lineValues = new double[values.length];
            for (int i = 0; i < lineValues.length; ++i) {
                lineValues[i] = values[i][index];
            }
            return lineValues;
        }
        return values[index];
    }

    private static final int firstValueIndex(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("No value found");
    }

    private static final int lastValueIndex(double[] values) {
        for (int i = values.length - 1; i >= 0; --i) {
            if (Double.isNaN(values[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("No value found");
    }
}

