/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.operations;

import es.uvigo.ei.sing.laimages.core.operations.BilinearInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.util.MathArrays;

public class BilinearInterpolator
implements BivariateGridInterpolator {
    public BilinearInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        if (yval.length != fval[0].length) {
            throw new DimensionMismatchException(yval.length, fval[0].length);
        }
        MathArrays.checkOrder((double[])xval);
        MathArrays.checkOrder((double[])yval);
        return new BilinearInterpolatingFunction(xval, yval, fval);
    }
}

