/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.operations;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

public class BilinearInterpolatingFunction
implements BivariateFunction {
    private final double[] xval;
    private final double[] yval;
    private final double[][] fval;

    public BilinearInterpolatingFunction(double[] xval, double[] yval, double[][] fval) throws DimensionMismatchException, NoDataException, NonMonotonicSequenceException {
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        if (yval.length != fval[0].length) {
            throw new DimensionMismatchException(yval.length, fval[0].length);
        }
        MathArrays.checkOrder((double[])xval);
        MathArrays.checkOrder((double[])yval);
        this.xval = xval;
        this.yval = yval;
        this.fval = fval;
    }

    public double value(double x, double y) {
        boolean inRow = this.isInRow(x);
        boolean inColumn = this.isInColumn(y);
        if (inRow && inColumn) {
            int i = this.getXIndex(x);
            int j = this.getYIndex(y);
            return this.fval[i][j];
        }
        if (inRow) {
            int i = this.getXIndex(x);
            int j1 = this.previousY(y);
            int j2 = this.nextY(y);
            double y1 = this.yval[j1];
            double y2 = this.yval[j2];
            double q1 = this.fval[i][j1];
            double q2 = this.fval[i][j2];
            return (y - y1) * (q2 - q1) / (y2 - y1) + q1;
        }
        if (inColumn) {
            int j = this.getYIndex(y);
            int i1 = this.previousX(x);
            int i2 = this.nextX(x);
            double x1 = this.xval[i1];
            double x2 = this.xval[i2];
            double q1 = this.fval[i1][j];
            double q2 = this.fval[i2][j];
            return (x - x1) * (q2 - q1) / (x2 - x1) + q1;
        }
        int i1 = this.previousX(x);
        int i2 = this.nextX(x);
        int j1 = this.previousY(y);
        int j2 = this.nextY(y);
        double x1 = this.xval[i1];
        double x2 = this.xval[i2];
        double y1 = this.yval[j1];
        double y2 = this.yval[j2];
        double q11 = this.fval[i1][j1];
        double q12 = this.fval[i1][j2];
        double q21 = this.fval[i2][j1];
        double q22 = this.fval[i2][j2];
        return (x2 - x) * (y2 - y) / ((x2 - x1) * (y2 - y1)) * q11 + (x - x1) * (y2 - y) / ((x2 - x1) * (y2 - y1)) * q21 + (x2 - x) * (y - y1) / ((x2 - x1) * (y2 - y1)) * q12 + (x - x1) * (y - y1) / ((x2 - x1) * (y2 - y1)) * q22;
    }

    private boolean isInRow(double x) {
        return BilinearInterpolatingFunction.isInArray(x, this.xval);
    }

    private boolean isInColumn(double y) {
        return BilinearInterpolatingFunction.isInArray(y, this.yval);
    }

    private int getXIndex(double x) {
        return BilinearInterpolatingFunction.indexOf(x, this.xval);
    }

    private int getYIndex(double y) {
        return BilinearInterpolatingFunction.indexOf(y, this.yval);
    }

    private static int indexOf(double value, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (value != values[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("value not found");
    }

    private static boolean isInArray(double value, double[] values) {
        for (double v : values) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    private int previousX(double x) {
        return BilinearInterpolatingFunction.previous(x, this.xval);
    }

    private int previousY(double y) {
        return BilinearInterpolatingFunction.previous(y, this.yval);
    }

    private int nextX(double x) {
        return BilinearInterpolatingFunction.next(x, this.xval);
    }

    private int nextY(double y) {
        return BilinearInterpolatingFunction.next(y, this.yval);
    }

    private static int previous(double value, double[] values) {
        if (value < values[0] || value > values[values.length - 1]) {
            throw new OutOfRangeException((Number)value, (Number)values[0], (Number)values[values.length - 1]);
        }
        for (int i = values.length - 1; i >= 0; --i) {
            if (Double.isNaN(values[i]) || !(values[i] < value)) continue;
            return i;
        }
        return 0;
    }

    private static int next(double value, double[] values) {
        if (value < values[0] || value > values[values.length - 1]) {
            throw new OutOfRangeException((Number)value, (Number)values[0], (Number)values[values.length - 1]);
        }
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i]) || !(values[i] > value)) continue;
            return i;
        }
        return values.length - 1;
    }
}

