/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.io.csv;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class CSVFormat {
    private String lineBreak;
    private String columnSeparator;
    private boolean quoteHeaders;
    private char decimalSeparator = (char)46;
    private final DecimalFormat decimalFormatter = new DecimalFormat("0.0000");
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());

    public CSVFormat(FileFormat format) throws IllegalArgumentException {
        switch (format) {
            case EXCEL: {
                this.columnSeparator = ";";
                this.lineBreak = "\r\n";
                this.quoteHeaders = false;
                break;
            }
            case LIBRE_OFFICE: {
                this.columnSeparator = this.symbols.getDecimalSeparator() == ',' ? ";" : ",";
                this.lineBreak = "\n";
                this.quoteHeaders = false;
                break;
            }
            case CUSTOM: {
                throw new IllegalArgumentException("FileFormat.CUSTOM cannot be used to construct a new instance. Use constructor with all options in this case.");
            }
        }
        this.decimalSeparator = this.symbols.getDecimalSeparator();
        this.configureFormaters();
    }

    public CSVFormat(String columnSeparator, char decimalSeparator, boolean quoteHeaders, String lineBreak) {
        this.columnSeparator = columnSeparator;
        this.lineBreak = lineBreak;
        this.quoteHeaders = quoteHeaders;
        this.decimalSeparator = decimalSeparator;
        this.configureFormaters();
    }

    private void configureFormaters() {
        if (this.decimalSeparator != this.symbols.getDecimalSeparator()) {
            this.symbols.setDecimalSeparator(this.decimalSeparator);
            this.decimalFormatter.setDecimalFormatSymbols(this.symbols);
        }
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public boolean isQuoteHeaders() {
        return this.quoteHeaders;
    }

    public DecimalFormat getDecimalFormatter() {
        return this.decimalFormatter;
    }

    public static enum FileFormat {
        CUSTOM("Custom"),
        EXCEL("Excel compatible CSV"),
        LIBRE_OFFICE("Libre/Open Office compatible CSV");

        private String description;

        private FileFormat(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

