/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.io.coordinates;

import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.AbstractLineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.HorizontalLineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.VerticalLineCoordinates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LineCoordinatesLoader {
    private static final String LINE_BLOCK_TAG = "LINE";

    public static final LineCoordinates[] loadCoordinates(File coordinatesFile, double xTick) throws IOException {
        return LineCoordinatesLoader.parseCoordinatesFile(coordinatesFile, xTick);
    }

    private static final LineCoordinates[] parseCoordinatesFile(File coordinatesFile, double xTick) throws IOException {
        List<String> lines = Files.readAllLines(coordinatesFile.toPath());
        List<LineCoordinates> coordinatesList = LineCoordinatesLoader.loadCoordinates(xTick, lines);
        LineCoordinatesLoader.alignCoordinates(coordinatesList);
        return coordinatesList.toArray(new LineCoordinates[coordinatesList.size()]);
    }

    private static List<LineCoordinates> loadCoordinates(double xTick, List<String> lines) {
        LinkedList<LineCoordinates> coordinatesList = new LinkedList<LineCoordinates>();
        Iterator<String> linesIt = lines.iterator();
        String previousLine = null;
        Coordinate start = null;
        while (linesIt.hasNext()) {
            String currentLine = linesIt.next();
            if (currentLine.equals(LINE_BLOCK_TAG)) {
                LineCoordinatesLoader.readEndLineAndAddCoordinate(xTick, coordinatesList, previousLine, start);
            } else if (previousLine.equals(LINE_BLOCK_TAG)) {
                start = LineCoordinatesLoader.readCoordinate(currentLine);
            }
            previousLine = currentLine;
        }
        LineCoordinatesLoader.readEndLineAndAddCoordinate(xTick, coordinatesList, previousLine, start);
        return coordinatesList;
    }

    private static void readEndLineAndAddCoordinate(double xTick, List<LineCoordinates> coordinatesList, String previousLine, Coordinate start) {
        Coordinate end = LineCoordinatesLoader.readCoordinate(previousLine);
        LineCoordinatesLoader.addLineCoordinates(coordinatesList, start, end, xTick);
    }

    private static void addLineCoordinates(List<LineCoordinates> coordinatesList, Coordinate start, Coordinate end, double xTick) {
        if (start == null || end == null) {
            return;
        }
        AbstractLineCoordinates newLineCoordinates = null;
        if (start.getX() == end.getX()) {
            double xStart = start.getY();
            double xEnd = end.getY();
            double y = start.getX();
            newLineCoordinates = new VerticalLineCoordinates(xTick, xStart, xEnd, y);
        } else {
            double xStart = start.getX();
            double xEnd = end.getX();
            double y = start.getY();
            newLineCoordinates = new HorizontalLineCoordinates(xTick, xStart, xEnd, y);
        }
        coordinatesList.add(newLineCoordinates);
    }

    private static Coordinate readCoordinate(String line) {
        if (line != null) {
            String[] split = line.split(",");
            return new Coordinate(Double.valueOf(split[0]), Double.valueOf(split[1]));
        }
        return null;
    }

    private static void alignCoordinates(List<LineCoordinates> coordinates) {
        List<Double> linesRangeAxis = LineCoordinatesUtils.getLinesRangeAxis(coordinates);
        for (LineCoordinates lC : coordinates) {
            double closest = LineCoordinatesLoader.findClosest(lC.getRangeStart(), linesRangeAxis);
            lC.setStartRangeCoordinate(closest);
            closest = LineCoordinatesLoader.findClosest(lC.getRangeEnd(), linesRangeAxis);
            lC.setEndRangeCoordinate(closest);
        }
    }

    private static final double findClosest(double target, List<Double> values) {
        double closest = Double.NaN;
        double minimumDifference = Double.MAX_VALUE;
        for (double value : values) {
            double difference = Math.abs(value - target);
            if (!(difference < minimumDifference)) continue;
            minimumDifference = difference;
            closest = value;
        }
        return closest;
    }

    static class Coordinate {
        private double x;
        private double y;

        public Coordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

