/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.io;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDatasetConfiguration;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.HorizontalLineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import es.uvigo.ei.sing.laimages.core.io.coordinates.LineCoordinatesLoader;
import es.uvigo.ei.sing.laimages.core.io.exception.InvalidDataException;
import es.uvigo.ei.sing.laimages.core.io.exception.PositionsFileNotFoundException;
import es.uvigo.ei.sing.laimages.core.util.FileNameUtils;
import es.uvigo.ei.sing.laimages.core.util.ProgressHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineToElementConverter {
    public static final String POSITIONS_FILE_NAME = "positions.txt";
    private static final Comparator<String> LINE_MAP_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return LineToElementConverter.getLineNumber(o1).compareTo(LineToElementConverter.getLineNumber(o2));
        }
    };
    private static final Comparator<File> LINE_FILES_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return LineToElementConverter.getLineNumber(o1.getName()).compareTo(LineToElementConverter.getLineNumber(o2.getName()));
        }
    };
    private FilenameFilter fileFilter;
    private File directory;
    private ElementDatasetConfiguration configuration;
    private LineCoordinates[] coordinates;
    private Map<String, Map<String, List<String>>> data;
    private Set<Integer> linesLength = new HashSet<Integer>();

    public LineToElementConverter(File directory, FilenameFilter fileFilter, ElementDatasetConfiguration configuration) throws IOException {
        this.directory = directory;
        this.fileFilter = fileFilter;
        this.configuration = configuration;
        this.process();
        this.coordinates = this.loadLineCoordinates(directory);
    }

    public LineToElementConverter(String directory, FilenameFilter fileFilter, ElementDatasetConfiguration configuration) throws IOException {
        this(new File(directory), fileFilter, configuration);
    }

    private void process() {
        this.data = new HashMap<String, Map<String, List<String>>>();
        for (File lineFile : this.getLineFiles()) {
            this.parseLineFile(this.data, lineFile);
        }
    }

    private File[] getLineFiles() {
        File[] files = this.directory.listFiles(this.fileFilter);
        Arrays.sort(files, LINE_FILES_COMPARATOR);
        return files;
    }

    private static final Integer getLineNumber(String lineName) {
        Pattern p = Pattern.compile("[0-9][0-9]*");
        Matcher m = p.matcher(lineName);
        if (m.find()) {
            int n = Integer.parseInt(m.group(0));
            return n;
        }
        return 0;
    }

    private void parseLineFile(Map<String, Map<String, List<String>>> data, File lineFile) {
        try {
            String lineName = lineFile.getName().replaceAll(" ", "_");
            Scanner input = new Scanner(lineFile);
            String[] headers = null;
            if (input.hasNextLine()) {
                input.nextLine();
            }
            if (input.hasNextLine()) {
                String header = input.nextLine();
                headers = header.split(",");
                for (int i = 1; i < headers.length; ++i) {
                    data.putIfAbsent(headers[i], new TreeMap(LINE_MAP_COMPARATOR));
                    data.get(headers[i]).putIfAbsent(lineName, new LinkedList());
                }
            }
            int lineLength = 0;
            while (input.hasNextLine()) {
                String line = input.nextLine();
                if (line.equals("")) continue;
                ++lineLength;
                String[] values = line.split(",");
                for (int i = 1; i < values.length; ++i) {
                    data.get(headers[i]).get(lineName).add(values[i]);
                }
            }
            this.linesLength.add(lineLength);
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<ElementData> getElements(ProgressHandler progressHandler) throws InvalidDataException {
        LinkedList<ElementData> elements = new LinkedList<ElementData>();
        for (String element : this.data.keySet()) {
            Map<String, List<String>> elementData = this.data.get(element);
            Iterator<String> lineIterator = elementData.keySet().iterator();
            LinkedList<LineData> lines = new LinkedList<LineData>();
            HashSet<Double> linesPositions = new HashSet<Double>();
            int lineIndex = 0;
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                double[] lineValues = LineToElementConverter.toDoubleArray(elementData.get(line));
                LineCoordinates currentCoordinates = this.coordinates[lineIndex];
                int validLineMeasurements = (int)(1L + Math.round((currentCoordinates.getRangeEnd() - currentCoordinates.getRangeStart()) / currentCoordinates.getRangeTick()));
                if (validLineMeasurements > lineValues.length) {
                    throw new InvalidDataException("The number of required measurements for line " + line + " is " + validLineMeasurements + " but file " + line + " contains only " + lineValues.length + " measurements. Please, check that the line length " + "and the data source file are correct.");
                }
                if (linesPositions.contains(currentCoordinates.getPosition())) {
                    progressHandler.warn(this.getSkippedLineMessage(line, currentCoordinates));
                } else {
                    lines.add(new LineData(line, Arrays.copyOfRange(lineValues, 0, validLineMeasurements), currentCoordinates));
                    linesPositions.add(currentCoordinates.getPosition());
                }
                ++lineIndex;
            }
            elements.add(ElementData.createElementData(element, lines.toArray(new LineData[lines.size()])));
        }
        return elements;
    }

    private String getSkippedLineMessage(String line, LineCoordinates currentCoordinates) {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ").append(line).append(" has been skipped since position ").append(currentCoordinates.getPosition()).append(" is already occupied.");
        return sb.toString();
    }

    private static final double[] toDoubleArray(List<String> list) {
        double[] toret = new double[list.size()];
        int i = 0;
        for (String s : list) {
            toret[i++] = Double.valueOf(s);
        }
        return toret;
    }

    private LineCoordinates[] loadLineCoordinates(File directory) throws IOException {
        File positionsFile = this.getPositionsFile(directory);
        if (!LineToElementConverter.checkPositionsFile(positionsFile)) {
            if (!this.allLinesHaveSameLength()) {
                throw new PositionsFileNotFoundException("Dataset directory must contain a fille called positions.txt specifying the line positions or all lines must have the same length.");
            }
            return this.generatePositions(this.getLinesCount(), this.getlinesLength());
        }
        return LineCoordinatesLoader.loadCoordinates(positionsFile, this.configuration.getLineRangeInterval());
    }

    private File getPositionsFile(File directory) {
        return FileNameUtils.findFileIgnoreCase(directory, POSITIONS_FILE_NAME).orElse(null);
    }

    private static final boolean checkPositionsFile(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    private int getLinesCount() {
        return this.getLineFiles().length;
    }

    private boolean allLinesHaveSameLength() {
        return this.getlinesLengths().size() == 1;
    }

    private Set<Integer> getlinesLengths() {
        HashSet<Integer> linesLengths = new HashSet<Integer>();
        for (Map.Entry<String, Map<String, List<String>>> element : this.data.entrySet()) {
            for (Map.Entry<String, List<String>> line : element.getValue().entrySet()) {
                linesLengths.add(line.getValue().size());
            }
        }
        return linesLengths;
    }

    private int getlinesLength() {
        return this.getlinesLengths().iterator().next();
    }

    private final LineCoordinates[] generatePositions(int lines, int measurements) {
        double incX = this.configuration.getAblationSpeed() * this.configuration.getAcquisitionTime();
        double incY = this.configuration.getSpaceInterval();
        double startX = 0.0;
        double endX = incX * (double)(measurements - 1);
        LineCoordinates[] lineCoordinates = new LineCoordinates[lines];
        for (int i = 0; i < lines; ++i) {
            lineCoordinates[i] = new HorizontalLineCoordinates(incX, startX, endX, incY * (double)i);
        }
        return lineCoordinates;
    }
}

