/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.io;

import es.uvigo.ei.sing.laimages.core.entities.datasets.DefaultElementDataset;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDataset;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDatasetConfiguration;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.io.LineToElementConverter;
import es.uvigo.ei.sing.laimages.core.io.exception.NoSuchStandardElementException;
import es.uvigo.ei.sing.laimages.core.io.exception.PositionsFileNotFoundException;
import es.uvigo.ei.sing.laimages.core.operations.NormalizeElementData;
import es.uvigo.ei.sing.laimages.core.util.ProgressHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LineDatasetLoader {
    private static final String[] extensions = new String[]{"xl"};
    private final FilenameFilter fileFilter = new ExtensionFilenameFilter(extensions);
    private final ElementDatasetConfiguration configuration;

    public LineDatasetLoader(ElementDatasetConfiguration configuration) {
        this.configuration = configuration;
    }

    public ElementDataset loadAndNormalizeDataset(Path path) throws IOException, NoSuchStandardElementException, PositionsFileNotFoundException {
        return this.loadAndNormalizeDataset(path, () -> {});
    }

    public ElementDataset loadAndNormalizeDataset(Path path, ProgressHandler progressHandler) throws IOException, NoSuchStandardElementException, PositionsFileNotFoundException {
        this.checkPath(path);
        DefaultElementDataset dataset = this.createDataset(path, this.loadElementData(path, progressHandler));
        this.normalizeCoordinates(dataset);
        return dataset;
    }

    private void checkPath(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            throw new IOException("Path must be a readable directory.");
        }
    }

    private List<ElementData> loadElementData(Path path, ProgressHandler progressHandler) throws IOException {
        LineToElementConverter converter = new LineToElementConverter(path.toFile(), this.fileFilter, this.configuration);
        return converter.getElements(progressHandler);
    }

    private DefaultElementDataset createDataset(Path path, List<ElementData> elements) throws NoSuchStandardElementException {
        DefaultElementDataset dataset = new DefaultElementDataset(path, path.getFileName().toString(), this.configuration);
        if (this.configuration.shouldNormalize()) {
            dataset.addElements(elements);
        } else {
            dataset.addElements(LineDatasetLoader.normalizeElementData(elements, this.configuration.getStandardElement()));
        }
        return dataset;
    }

    private static final List<ElementData> normalizeElementData(List<ElementData> elements, String standardElement) throws NoSuchStandardElementException {
        ElementData standardElementData = LineDatasetLoader.getStandardElementData(elements, standardElement);
        return NormalizeElementData.normalize(standardElementData, elements).stream().filter(e -> !e.getName().equals(standardElement)).collect(Collectors.toList());
    }

    private static final ElementData getStandardElementData(List<ElementData> elements, String standardElement) throws NoSuchStandardElementException {
        Optional<ElementData> standardElementData = elements.stream().filter(e -> e.getName().equals(standardElement)).findFirst();
        if (standardElementData.isPresent()) {
            return standardElementData.get();
        }
        throw new NoSuchStandardElementException("Standard element " + standardElement + " is not present in the dataset");
    }

    private void normalizeCoordinates(DefaultElementDataset dataset) {
        if (dataset.getElementCount() > 0) {
            LineCoordinatesUtils.normalizeCoordinates(Stream.of(dataset.getElements().get(0).getLines()).map(LineData::getCoordinates).collect(Collectors.toList()), this.configuration);
        }
    }

    private static final class ExtensionFilenameFilter
    implements FilenameFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String[] extensions;

        public ExtensionFilenameFilter(String ... extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            return Stream.of(this.extensions).filter(e -> name.toLowerCase().endsWith((String)e)).count() > 0L;
        }
    }
}

