/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDatasetConfiguration;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public class LineCoordinatesUtils {
    public static boolean areVertical(LineData[] lines) {
        return Stream.of(lines).allMatch(LineData::isVertical);
    }

    public static boolean areHorizontal(LineData[] lines) {
        return Stream.of(lines).noneMatch(LineData::isVertical);
    }

    public static List<Double> getLinesPositionsAxis(List<LineCoordinates> coordinates) {
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        return coordinates.stream().map(LineCoordinates::getPosition).collect(Collectors.toList());
    }

    public static List<Double> getLinesRangeAxis(List<LineCoordinates> coordinates) {
        LineCoordinatesUtils.requireCompatibleCoordinates(coordinates);
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        Range xRange = LineCoordinatesUtils.findMinAndMaxXValues(coordinates);
        return xRange.sequence(coordinates.get(0).getRangeTick());
    }

    private static final void requireCompatibleCoordinates(List<LineCoordinates> coordinates) {
        Set rangeTicks = coordinates.stream().map(LineCoordinates::getRangeTick).collect(Collectors.toSet());
        if (rangeTicks.size() > 1) {
            throw new IllegalArgumentException("All coordinates must have the same range interval");
        }
    }

    private static final Range findMinAndMaxXValues(List<LineCoordinates> coordinates) {
        double minX = Double.MAX_VALUE;
        double maxX = 0.0;
        for (LineCoordinates lC : coordinates) {
            if (lC.getRangeStart() < minX) {
                minX = lC.getRangeStart();
            }
            if (!(lC.getRangeEnd() > maxX)) continue;
            maxX = lC.getRangeEnd();
        }
        return new Range(minX, maxX);
    }

    public static boolean haveDifferentPositions(LineData[] lines) {
        return LineCoordinatesUtils.getPositionsStream(lines).count() == LineCoordinatesUtils.getPositionsStream(lines).distinct().count();
    }

    private static DoubleStream getPositionsStream(LineData[] lines) {
        return Stream.of(lines).map(LineData::getCoordinates).mapToDouble(LineCoordinates::getPosition);
    }

    public static final void normalizeCoordinates(List<LineCoordinates> coordinates, ElementDatasetConfiguration configuration) {
        double minRangeValue = coordinates.stream().mapToDouble(LineCoordinates::getRangeStart).min().getAsDouble();
        double tick = configuration.getPositionInterval();
        for (int i = 0; i < coordinates.size(); ++i) {
            LineCoordinates current = coordinates.get(i);
            current.setStartRangeCoordinate(current.getRangeStart() - minRangeValue);
            current.setEndRangeCoordinate(current.getRangeEnd() - minRangeValue);
            current.setPosition(tick * (double)i);
        }
    }

    static class Range {
        private double min;
        private double max;

        public Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public List<Double> sequence(double xTick) {
            ArrayList<Double> sequence = new ArrayList<Double>();
            double last = 0.0;
            int count = 0;
            while (last < this.max) {
                last = this.min + (double)count * xTick;
                sequence.add(last);
                ++count;
            }
            return sequence;
        }
    }
}

