/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates;

import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import java.io.Serializable;

public abstract class AbstractLineCoordinates
implements LineCoordinates,
Serializable {
    private static final long serialVersionUID = 1L;
    private double rangeTick;
    private double rangeStart;
    private double rangeEnd;
    private double position;

    public AbstractLineCoordinates(double rangeTick, double rangeStart, double rangeEnd, double position) {
        if (rangeTick <= 0.0) {
            throw new IllegalArgumentException("Line range interval size must be greater than 0");
        }
        if (rangeStart > rangeEnd) {
            throw new IllegalArgumentException("End range point must be higher than start range point");
        }
        this.rangeTick = rangeTick;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.position = position;
    }

    @Override
    public double getRangeStart() {
        return this.rangeStart;
    }

    @Override
    public double getRangeEnd() {
        return this.rangeEnd;
    }

    @Override
    public double getRangeTick() {
        return this.rangeTick;
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public void setStartRangeCoordinate(double xStart) {
        this.rangeStart = xStart;
    }

    @Override
    public void setEndRangeCoordinate(double xEnd) {
        this.rangeEnd = xEnd;
    }

    @Override
    public void setPosition(double position) {
        this.position = position;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractLineCoordinates)) {
            return false;
        }
        AbstractLineCoordinates anotherLC = (AbstractLineCoordinates)obj;
        return this.getRangeTick() == anotherLC.getRangeTick() && this.getRangeStart() == anotherLC.getRangeStart() && this.getRangeEnd() == anotherLC.getRangeEnd() && this.getPosition() == anotherLC.getPosition() && this.isVertical() == anotherLC.isVertical();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LineCoordinates: line range = [").append(this.rangeStart).append(", ").append(this.rangeEnd).append("] by ").append(this.rangeTick).append(" ; line position = ").append(this.position).append(". Orientation: ").append(this.isVertical() ? "vertical" : "horizontal").append(".");
        return sb.toString();
    }
}

