/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets;

import es.uvigo.ei.sing.laimages.core.entities.datasets.AbstractElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import java.text.DecimalFormat;
import java.util.List;

public class VerticalElementData
extends AbstractElementData {
    private static final long serialVersionUID = 1L;

    public VerticalElementData(String name, LineData[] lines) {
        super(name, lines);
    }

    @Override
    protected void checkLinesArray(LineData[] lines) {
        super.checkLinesArray(lines);
        if (!LineCoordinatesUtils.areVertical(lines)) {
            throw new IllegalArgumentException("All lines must have have vertical orientation");
        }
    }

    @Override
    public double[][] getData(double missingValue) {
        List<Double> xAxis = this.getXAxis();
        List<Double> yAxis = this.getYAxis();
        double[][] data = new double[yAxis.size()][xAxis.size()];
        for (LineData line : this.getLines()) {
            int startYIndex = VerticalElementData.indexOf(yAxis, line.getCoordinates().getRangeStart(), 1.0E-6);
            int endYIndex = startYIndex + line.getLength();
            int xIndex = VerticalElementData.indexOf(xAxis, line.getCoordinates().getPosition(), 1.0E-6);
            for (int row = 0; row < yAxis.size(); ++row) {
                data[row][xIndex] = row >= startYIndex && row < endYIndex ? line.getData()[row - startYIndex] : missingValue;
            }
        }
        return data;
    }

    @Override
    public List<Double> getXAxis() {
        return LineCoordinatesUtils.getLinesPositionsAxis(this.getAllCoordinates());
    }

    @Override
    public List<Double> getYAxis() {
        return LineCoordinatesUtils.getLinesRangeAxis(this.getAllCoordinates());
    }

    @Override
    protected void writeLines(StringBuilder sb, CSVFormat format) {
        List<Double> xAxis = this.getXAxis();
        List<Double> yAxis = this.getYAxis();
        DecimalFormat formatter = format.getDecimalFormatter();
        for (Double y : yAxis) {
            int yIndex = VerticalElementData.indexOf(yAxis, y, 1.0E-6);
            sb.append(formatter.format(y)).append(format.getColumnSeparator());
            for (Double x : xAxis) {
                int xIndex = VerticalElementData.indexOf(xAxis, x, 1.0E-6);
                LineData line = this.getLines()[xIndex];
                double lineRangeStart = line.getCoordinates().getRangeStart();
                double lineRangeEnd = line.getCoordinates().getRangeEnd();
                int lineRangeStartIndex = VerticalElementData.indexOf(yAxis, lineRangeStart, 1.0E-6);
                if (y >= lineRangeStart && y <= lineRangeEnd) {
                    sb.append(formatter.format(line.getData()[yIndex - lineRangeStartIndex]));
                }
                if (xIndex >= xAxis.size() - 1) continue;
                sb.append(format.getColumnSeparator());
            }
            sb.append(format.getLineBreak());
        }
    }
}

