/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets;

import es.uvigo.ei.sing.laimages.core.entities.datasets.AbstractElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import java.text.DecimalFormat;
import java.util.List;

public class HorizontalElementData
extends AbstractElementData {
    private static final long serialVersionUID = 1L;

    public HorizontalElementData(String name, LineData[] lines) {
        super(name, lines);
    }

    @Override
    protected void checkLinesArray(LineData[] lines) {
        super.checkLinesArray(lines);
        if (!LineCoordinatesUtils.areHorizontal(lines)) {
            throw new IllegalArgumentException("All lines must have have horizontal orientation");
        }
    }

    @Override
    public double[][] getData(double missingValue) {
        List<Double> xAxis = this.getXAxis();
        List<Double> yAxis = this.getYAxis();
        double[][] data = new double[yAxis.size()][xAxis.size()];
        for (LineData line : this.getLines()) {
            int startXIndex = HorizontalElementData.indexOf(xAxis, line.getCoordinates().getRangeStart(), 1.0E-6);
            int endXIndex = startXIndex + line.getLength();
            int yIndex = HorizontalElementData.indexOf(yAxis, line.getCoordinates().getPosition(), 1.0E-6);
            for (int column = 0; column < xAxis.size(); ++column) {
                data[yIndex][column] = column >= startXIndex && column < endXIndex ? line.getData()[column - startXIndex] : missingValue;
            }
        }
        return data;
    }

    @Override
    public List<Double> getXAxis() {
        return LineCoordinatesUtils.getLinesRangeAxis(this.getAllCoordinates());
    }

    @Override
    public List<Double> getYAxis() {
        return LineCoordinatesUtils.getLinesPositionsAxis(this.getAllCoordinates());
    }

    @Override
    protected void writeLines(StringBuilder sb, CSVFormat format) {
        List<Double> xAxis = this.getXAxis();
        DecimalFormat formatter = format.getDecimalFormatter();
        for (LineData line : this.getLines()) {
            double y = line.getCoordinates().getPosition();
            sb.append(formatter.format(y)).append(format.getColumnSeparator());
            int startXIndex = HorizontalElementData.indexOf(xAxis, line.getCoordinates().getRangeStart(), 1.0E-6);
            int endXIndex = startXIndex + line.getLength();
            for (int column = 0; column < xAxis.size(); ++column) {
                if (column >= startXIndex && column < endXIndex) {
                    sb.append(formatter.format(line.getData()[column - startXIndex]));
                }
                if (column >= xAxis.size() - 1) continue;
                sb.append(format.getColumnSeparator());
            }
            sb.append(format.getLineBreak());
        }
    }
}

