/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets;

import es.uvigo.ei.sing.laimages.core.entities.datasets.HorizontalElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.VerticalElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface ElementData {
    public String getName();

    public double[][] getData(double var1);

    public List<Double> getXAxis();

    public List<Double> getYAxis();

    public LineData[] getLines();

    public int getNumLines();

    public boolean isCompatibleWith(ElementData var1);

    public double getMaxValue();

    public double getMinValue();

    public LineCoordinates[] getCoordinates();

    public void toCSV(File var1, CSVFormat var2) throws IOException;

    public boolean isVertical();

    public static ElementData createElementData(String name, LineData[] lines) {
        if (LineCoordinatesUtils.areVertical(lines)) {
            return new VerticalElementData(name, lines);
        }
        if (LineCoordinatesUtils.areHorizontal(lines)) {
            return new HorizontalElementData(name, lines);
        }
        throw new IllegalArgumentException("All lines must have the same orientation");
    }
}

