/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDataset;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDatasetConfiguration;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import es.uvigo.ei.sing.laimages.core.util.FileNameUtils;
import es.uvigo.ei.sing.laimages.core.util.ProgressHandler;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultElementDataset
implements ElementDataset,
Serializable {
    private static final long serialVersionUID = 1L;
    private File path;
    private String name;
    private List<ElementData> elements;
    private ElementDatasetConfiguration configuration;
    private Double maxValue;
    private Double minValue;

    public DefaultElementDataset(Path path, String name, ElementDatasetConfiguration configuration) {
        this.path = path.toFile();
        this.name = name;
        this.elements = new LinkedList<ElementData>();
        this.configuration = configuration;
    }

    public DefaultElementDataset(ElementDataset dataset) {
        this.path = dataset.getPath().toFile();
        this.name = dataset.getName();
        this.elements = new LinkedList<ElementData>(dataset.getElements());
        this.configuration = dataset.getConfiguration();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getElementCount() {
        return this.getElements().size();
    }

    @Override
    public List<ElementData> getElements() {
        return this.elements;
    }

    @Override
    public ElementDatasetConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public double getMinValue() {
        if (this.minValue == null) {
            this.minValue = this.getElements().stream().mapToDouble(ElementData::getMinValue).min().getAsDouble();
        }
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getElements().stream().mapToDouble(ElementData::getMaxValue).max().getAsDouble();
        }
        return this.maxValue;
    }

    public void addElement(ElementData e) {
        this.elements.add(e);
    }

    public void addElements(List<ElementData> e) {
        this.elements.addAll(e);
    }

    @Override
    public List<String> getElementNames() {
        return this.getElements().stream().map(ElementData::getName).collect(Collectors.toList());
    }

    @Override
    public Optional<ElementData> getElement(String name) {
        return this.getElements().stream().filter(e -> e.getName().equals(name)).findFirst();
    }

    @Override
    public Path getPath() {
        return this.path.toPath();
    }

    @Override
    public void toCSV(ElementData elementData, File file, CSVFormat format) throws IOException {
        elementData.toCSV(file, format);
    }

    @Override
    public void toCSV(File directory, CSVFormat format) throws IOException {
        this.toCSV(directory, format, () -> {});
    }

    @Override
    public void toCSV(File directory, CSVFormat format, ProgressHandler progressHandler) throws IOException {
        for (ElementData e : this.getElements()) {
            File elementFile = FileNameUtils.getFile(directory.toString(), e.getName(), ".csv");
            this.toCSV(e, elementFile, format);
            progressHandler.progress();
        }
    }
}

