/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.core.entities.datasets;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.LineData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinates;
import es.uvigo.ei.sing.laimages.core.entities.datasets.coordinates.LineCoordinatesUtils;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public abstract class AbstractElementData
implements ElementData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final double DELTA = 1.0E-6;
    protected final LineData[] lines;
    protected String name;
    private double maxValue = Double.MIN_VALUE;

    public AbstractElementData(String name, LineData[] lines) {
        this.checkLinesArray(lines);
        this.name = name;
        this.lines = lines;
    }

    protected void checkLinesArray(LineData[] lines) {
        if (lines.length == 0 || AbstractElementData.thereAreEmtyLines(lines)) {
            throw new IllegalArgumentException("Data can't be empty");
        }
        if (!LineCoordinatesUtils.haveDifferentPositions(lines)) {
            throw new IllegalArgumentException("Each LineData must have a different position");
        }
    }

    private static boolean thereAreEmtyLines(LineData[] lineData) {
        return Stream.of(lineData).map(LineData::isEmpty).anyMatch(empty -> empty == true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected List<LineCoordinates> getAllCoordinates() {
        return Stream.of(this.lines).map(LineData::getCoordinates).collect(Collectors.toList());
    }

    @Override
    public int getNumLines() {
        return this.lines.length;
    }

    @Override
    public boolean isCompatibleWith(ElementData data) {
        return this.getNumLines() == data.getNumLines() && this.areAllDataLinesCompatibleWith(data);
    }

    private boolean areAllDataLinesCompatibleWith(ElementData data) {
        for (int i = 0; i < this.lines.length; ++i) {
            boolean differentOrientation;
            boolean differentLength = this.lines[i].getLength() != data.getLines()[i].getLength();
            boolean bl = differentOrientation = this.lines[i].isVertical() != data.getLines()[i].isVertical();
            if (!differentLength && !differentOrientation) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getMaxValue() {
        if (this.maxValue == Double.MIN_VALUE) {
            this.maxValue = Arrays.stream(this.getLines()).map(LineData::getData).flatMapToDouble(DoubleStream::of).max().orElseThrow(() -> new IllegalStateException("No values found"));
        }
        return this.maxValue;
    }

    @Override
    public double getMinValue() {
        return Stream.of(this.getData(0.0)).flatMapToDouble(DoubleStream::of).min().getAsDouble();
    }

    @Override
    public LineData[] getLines() {
        return this.lines;
    }

    @Override
    public LineCoordinates[] getCoordinates() {
        return (LineCoordinates[])Stream.of(this.getLines()).map(LineData::getCoordinates).toArray(LineCoordinates[]::new);
    }

    @Override
    public boolean isVertical() {
        return this.getLines()[0].isVertical();
    }

    @Override
    public void toCSV(File file, CSVFormat format) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.writeXAxis(sb, format);
        this.writeLines(sb, format);
        Files.write(file.toPath(), sb.toString().getBytes(), new OpenOption[0]);
    }

    private final void writeXAxis(StringBuilder sb, CSVFormat format) {
        List<Double> xAxis = this.getXAxis();
        sb.append(format.getColumnSeparator());
        for (int column = 0; column < xAxis.size(); ++column) {
            sb.append(format.getDecimalFormatter().format(xAxis.get(column)));
            if (column >= xAxis.size() - 1) continue;
            sb.append(format.getColumnSeparator());
        }
        sb.append(format.getLineBreak());
    }

    protected static int indexOf(Collection<Double> collection, double value, double delta) {
        int i = 0;
        for (double v : collection) {
            if (Math.abs(v - value) <= delta) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected abstract void writeLines(StringBuilder var1, CSVFormat var2);
}

