/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import il.ac.idc.jdt.BoundingBox;
import il.ac.idc.jdt.Circle;
import il.ac.idc.jdt.Point;
import java.io.Serializable;

public class Triangle
implements Serializable {
    private static final long serialVersionUID = -5260987553362967534L;
    private Point a;
    private Point b;
    private Point c;
    private Triangle abTriangle;
    private Triangle bcTriangle;
    private Triangle caTriangle;
    private Circle circum;
    private int mc = 0;
    private boolean halfplane = false;
    private boolean mark = false;

    public Triangle(Point A, Point B, Point C) {
        this.a = A;
        int res = C.pointLineTest(A, B);
        if (res <= 1 || res == 3 || res == 4) {
            this.b = B;
            this.c = C;
        } else {
            System.out.println("Warning, ajTriangle(A,B,C) expects points in counterclockwise order.");
            System.out.println("" + A + B + C);
            this.b = C;
            this.c = B;
        }
        this.circumcircle();
    }

    public Triangle(Point A, Point B) {
        this.a = A;
        this.b = B;
        this.halfplane = true;
    }

    public BoundingBox getBoundingBox() {
        Point lowerLeft = new Point(Math.min(this.a.getX(), Math.min(this.b.getX(), this.c.getX())), Math.min(this.a.getY(), Math.min(this.b.getY(), this.c.getY())));
        Point upperRight = new Point(Math.max(this.a.getX(), Math.max(this.b.getX(), this.c.getX())), Math.max(this.a.getY(), Math.max(this.b.getY(), this.c.getY())));
        return new BoundingBox(lowerLeft, upperRight);
    }

    void switchneighbors(Triangle oldTriangle, Triangle newTriangle) {
        if (this.abTriangle == oldTriangle) {
            this.abTriangle = newTriangle;
        } else if (this.bcTriangle == oldTriangle) {
            this.bcTriangle = newTriangle;
        } else if (this.caTriangle == oldTriangle) {
            this.caTriangle = newTriangle;
        } else {
            System.out.println("Error, switchneighbors can't find Old.");
        }
    }

    Triangle neighbor(Point p) {
        if (this.a == p) {
            return this.caTriangle;
        }
        if (this.b == p) {
            return this.abTriangle;
        }
        if (this.c == p) {
            return this.bcTriangle;
        }
        System.out.println("Error, neighbors can't find p: " + p);
        return null;
    }

    Triangle nextNeighbor(Point p, Triangle prevTriangle) {
        Triangle neighbor = null;
        if (this.a.equals(p)) {
            neighbor = this.caTriangle;
        }
        if (this.b.equals(p)) {
            neighbor = this.abTriangle;
        }
        if (this.c.equals(p)) {
            neighbor = this.bcTriangle;
        }
        if (neighbor.equals(prevTriangle) || neighbor.isHalfplane()) {
            if (this.a.equals(p)) {
                neighbor = this.abTriangle;
            }
            if (this.b.equals(p)) {
                neighbor = this.bcTriangle;
            }
            if (this.c.equals(p)) {
                neighbor = this.caTriangle;
            }
        }
        return neighbor;
    }

    Circle circumcircle() {
        double u = ((this.a.getX() - this.b.getX()) * (this.a.getX() + this.b.getX()) + (this.a.getY() - this.b.getY()) * (this.a.getY() + this.b.getY())) / 2.0;
        double v = ((this.b.getX() - this.c.getX()) * (this.b.getX() + this.c.getX()) + (this.b.getY() - this.c.getY()) * (this.b.getY() + this.c.getY())) / 2.0;
        double den = (this.a.getX() - this.b.getX()) * (this.b.getY() - this.c.getY()) - (this.b.getX() - this.c.getX()) * (this.a.getY() - this.b.getY());
        if (den == 0.0) {
            this.circum = new Circle(this.a, Double.POSITIVE_INFINITY);
        } else {
            Point cen = new Point((u * (this.b.getY() - this.c.getY()) - v * (this.a.getY() - this.b.getY())) / den, (v * (this.a.getX() - this.b.getX()) - u * (this.b.getX() - this.c.getX())) / den);
            this.circum = new Circle(cen, cen.distance2(this.a));
        }
        return this.circum;
    }

    boolean circumcircleContains(Point p) {
        return this.circum.radius() > this.circum.center().distance2(p);
    }

    public String toString() {
        String res = "";
        res = res + this.a.toString() + this.b.toString();
        if (!this.halfplane) {
            res = res + this.c.toString();
        }
        return res;
    }

    public boolean contains(Point p) {
        boolean ans = false;
        if (this.halfplane || p == null) {
            return false;
        }
        if (this.isCorner(p)) {
            return true;
        }
        int a12 = p.pointLineTest(this.a, this.b);
        int a23 = p.pointLineTest(this.b, this.c);
        int a31 = p.pointLineTest(this.c, this.a);
        if (a12 == 1 && a23 == 1 && a31 == 1 || a12 == 2 && a23 == 2 && a31 == 2 || a12 == 0 || a23 == 0 || a31 == 0) {
            ans = true;
        }
        return ans;
    }

    public boolean containsBoundaryIsOutside(Point p) {
        boolean ans = false;
        if (this.halfplane || p == null) {
            return false;
        }
        if (this.isCorner(p)) {
            return true;
        }
        int a12 = p.pointLineTest(this.a, this.b);
        int a23 = p.pointLineTest(this.b, this.c);
        int a31 = p.pointLineTest(this.c, this.a);
        if (a12 == 1 && a23 == 1 && a31 == 1 || a12 == 2 && a23 == 2 && a31 == 2) {
            ans = true;
        }
        return ans;
    }

    public boolean isCorner(Point p) {
        return p.getX() == this.a.getX() && p.getY() == this.a.getY() || p.getX() == this.b.getX() && p.getY() == this.b.getY() || p.getX() == this.c.getX() && p.getY() == this.c.getY();
    }

    public boolean fallInsideCircumcircle(Point[] arrayPoints) {
        boolean isInside = false;
        Point p1 = this.getA();
        Point p2 = this.getB();
        Point p3 = this.getC();
        for (int i = 0; !isInside && i < arrayPoints.length; ++i) {
            Point p = arrayPoints[i];
            if (p.equals(p1) || p.equals(p2) || p.equals(p3)) continue;
            isInside = this.circumcircleContains(p);
        }
        return isInside;
    }

    public double zValue(Point q) {
        if (q == null || this.halfplane) {
            throw new RuntimeException("*** ERR wrong parameters, can't approximate the z value ..***: " + q);
        }
        if (q.getX() == this.a.getX() && q.getY() == this.a.getY()) {
            return this.a.getZ();
        }
        if (q.getX() == this.b.getX() && q.getY() == this.b.getY()) {
            return this.b.getZ();
        }
        if (q.getX() == this.c.getX() && q.getY() == this.c.getY()) {
            return this.c.getZ();
        }
        double X = 0.0;
        double x0 = q.getX();
        double x1 = this.a.getX();
        double x2 = this.b.getX();
        double x3 = this.c.getX();
        double Y = 0.0;
        double y0 = q.getY();
        double y1 = this.a.getY();
        double y2 = this.b.getY();
        double y3 = this.c.getY();
        double Z = 0.0;
        double m01 = 0.0;
        double k01 = 0.0;
        double m23 = 0.0;
        double k23 = 0.0;
        int flag01 = 0;
        if (x0 != x1) {
            m01 = (y0 - y1) / (x0 - x1);
            k01 = y0 - m01 * x0;
            if (m01 == 0.0) {
                flag01 = 1;
            }
        } else {
            flag01 = 2;
        }
        int flag23 = 0;
        if (x2 != x3) {
            m23 = (y2 - y3) / (x2 - x3);
            k23 = y2 - m23 * x2;
            if (m23 == 0.0) {
                flag23 = 1;
            }
        } else {
            flag23 = 2;
        }
        if (flag01 == 2) {
            X = x0;
            Y = m23 * X + k23;
        } else if (flag23 == 2) {
            X = x2;
            Y = m01 * X + k01;
        } else {
            X = (k23 - k01) / (m01 - m23);
            Y = m01 * X + k01;
        }
        double r = 0.0;
        r = flag23 == 2 ? (y2 - Y) / (y2 - y3) : (x2 - X) / (x2 - x3);
        Z = this.b.getZ() + (this.c.getZ() - this.b.getZ()) * r;
        r = flag01 == 2 ? (y1 - y0) / (y1 - Y) : (x1 - x0) / (x1 - X);
        double qZ = this.a.getZ() + (Z - this.a.getZ()) * r;
        return qZ;
    }

    public double getZ(double x, double y) {
        return this.zValue(new Point(x, y));
    }

    public Point getZ(Point q) {
        double z = this.zValue(q);
        return new Point(q.getX(), q.getY(), z);
    }

    public boolean isMark() {
        return this.mark;
    }

    public void setMark(boolean mark) {
        this.mark = mark;
    }

    public int getMc() {
        return this.mc;
    }

    public boolean isHalfplane() {
        return this.halfplane;
    }

    public void setHalfplane(boolean halfplane) {
        this.halfplane = halfplane;
    }

    public void setMc(int mc) {
        this.mc = mc;
    }

    public Triangle getAbTriangle() {
        return this.abTriangle;
    }

    public void setAbTriangle(Triangle abTriangle) {
        this.abTriangle = abTriangle;
    }

    public Triangle getBcTriangle() {
        return this.bcTriangle;
    }

    public void setBcTriangle(Triangle bcTriangle) {
        this.bcTriangle = bcTriangle;
    }

    public Triangle getCaTriangle() {
        return this.caTriangle;
    }

    public void setCanext(Triangle canext) {
        this.caTriangle = canext;
    }

    public Point getA() {
        return this.a;
    }

    public void setA(Point a) {
        this.a = a;
    }

    public Point getB() {
        return this.b;
    }

    public void setB(Point b) {
        this.b = b;
    }

    public Point getC() {
        return this.c;
    }

    public void setC(Point c) {
        this.c = c;
    }
}

