/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import java.io.Serializable;

public class Point
implements Comparable<Point>,
Serializable {
    private static final long serialVersionUID = -2171877036557953047L;
    private double x;
    private double y;
    private double z;
    public static final int ONSEGMENT = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int INFRONTOFA = 3;
    public static final int BEHINDB = 4;
    public static final int ERROR = 5;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(double x, double y) {
        this(x, y, 0.0);
    }

    public Point(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    double distance2(Point p) {
        return (p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y);
    }

    double distance2(double px, double py) {
        return (px - this.x) * (px - this.x) + (py - this.y) * (py - this.y);
    }

    boolean isLess(Point p) {
        return this.compareTo(p) < 0;
    }

    boolean isGreater(Point p) {
        return this.compareTo(p) > 0;
    }

    public String toString() {
        return "Point [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public double distance(Point p) {
        double temp = Math.pow(p.getX() - this.x, 2.0) + Math.pow(p.getY() - this.y, 2.0);
        return Math.sqrt(temp);
    }

    public double distance3D(Point p) {
        double temp = Math.pow(p.getX() - this.x, 2.0) + Math.pow(p.getY() - this.y, 2.0) + Math.pow(p.getZ() - this.z, 2.0);
        return Math.sqrt(temp);
    }

    public int pointLineTest(Point a, Point b) {
        double dy = b.y - a.y;
        double dx = b.x - a.x;
        double res = dy * (this.x - a.x) - dx * (this.y - a.y);
        if (res < 0.0) {
            return 1;
        }
        if (res > 0.0) {
            return 2;
        }
        if (dx > 0.0) {
            if (this.x < a.x) {
                return 3;
            }
            if (b.x < this.x) {
                return 4;
            }
            return 0;
        }
        if (dx < 0.0) {
            if (this.x > a.x) {
                return 3;
            }
            if (b.x > this.x) {
                return 4;
            }
            return 0;
        }
        if (dy > 0.0) {
            if (this.y < a.y) {
                return 3;
            }
            if (b.y < this.y) {
                return 4;
            }
            return 0;
        }
        if (dy < 0.0) {
            if (this.y > a.y) {
                return 3;
            }
            if (b.y > this.y) {
                return 4;
            }
            return 0;
        }
        System.out.println("Error, pointLineTest with a=b");
        return 5;
    }

    boolean areCollinear(Point a, Point b) {
        double dy = b.y - a.y;
        double dx = b.x - a.x;
        double res = dy * (this.x - a.x) - dx * (this.y - a.y);
        return res == 0.0;
    }

    Point circumcenter(Point a, Point b) {
        double u = ((a.x - b.x) * (a.x + b.x) + (a.y - b.y) * (a.y + b.y)) / 2.0;
        double v = ((b.x - this.x) * (b.x + this.x) + (b.y - this.y) * (b.y + this.y)) / 2.0;
        double den = (a.x - b.x) * (b.y - this.y) - (b.x - this.x) * (a.y - b.y);
        if (den == 0.0) {
            System.out.println("circumcenter, degenerate case");
        }
        return new Point((u * (b.y - this.y) - v * (a.y - b.y)) / den, (v * (a.x - b.x) - u * (b.x - this.x)) / den);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    @Override
    public int compareTo(Point o) {
        if (o == null) {
            return 1;
        }
        Point d1 = this;
        Point d2 = o;
        if (d1.getX() > d2.getX()) {
            return 1;
        }
        if (d1.getX() < d2.getX()) {
            return -1;
        }
        if (d1.getY() > d2.getY()) {
            return 1;
        }
        if (d1.getY() < d2.getY()) {
            return -1;
        }
        return 0;
    }
}

