/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import il.ac.idc.jdt.Point;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = 3096537227117306103L;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;

    public BoundingBox() {
        this.setToNull();
    }

    public BoundingBox(BoundingBox other) {
        if (other.isNull()) {
            this.setToNull();
        } else {
            this.init(other.minX, other.maxX, other.minY, other.maxY, other.minZ, other.maxZ);
        }
    }

    public BoundingBox(double minx, double maxx, double miny, double maxy, double minz, double maxz) {
        this.init(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox(Point lowerLeft, Point upperRight) {
        this.init(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY(), lowerLeft.getZ(), upperRight.getZ());
    }

    private void init(double x1, double x2, double y1, double y2, double z1, double z2) {
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (y1 < y2) {
            this.minY = y1;
            this.maxY = y2;
        } else {
            this.minY = y2;
            this.maxY = y1;
        }
        if (z1 < z2) {
            this.minZ = z1;
            this.maxZ = z2;
        } else {
            this.minZ = z2;
            this.maxZ = z1;
        }
    }

    private void setToNull() {
        this.minX = 0.0;
        this.maxX = -1.0;
        this.minY = 0.0;
        this.maxY = -1.0;
    }

    public boolean isNull() {
        return this.maxX < this.minX;
    }

    public boolean contains(BoundingBox other) {
        return !this.isNull() && !other.isNull() && other.minX >= this.minX && other.maxY <= this.maxX && other.minY >= this.minY && other.maxY <= this.maxY;
    }

    public BoundingBox unionWith(BoundingBox other) {
        if (other.isNull()) {
            return new BoundingBox(this);
        }
        if (this.isNull()) {
            return new BoundingBox(other);
        }
        return new BoundingBox(Math.min(this.minX, other.minX), Math.max(this.maxX, other.maxX), Math.min(this.minY, other.minY), Math.max(this.maxY, other.maxY), Math.min(this.minZ, other.minZ), Math.max(this.maxZ, other.maxZ));
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public String toString() {
        return "BoundingBox [minX=" + this.minX + ", maxX=" + this.maxX + ", minY=" + this.minY + ", maxY=" + this.maxY + ", minZ=" + this.minZ + ", maxZ=" + this.maxZ + "]";
    }

    public Point getMinPoint() {
        return new Point(this.minX, this.minY, this.minZ);
    }

    public Point getMaxPoint() {
        return new Point(this.maxX, this.maxY, this.maxZ);
    }
}

