/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.wizard;

import es.uvigo.ei.aibench.workbench.wizard.WizardStep;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Wizard
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonsPanel = null;
    private JButton nextButton = null;
    private JButton cancelButton = null;
    private JPanel stepContentPanel = null;
    private Object userObject;
    private WizardStep[] steps;
    private int currentStep = 0;
    private int initialWidth = 552;
    private int initialHeight = 411;
    private CardLayout assistantLayout;
    private JLabel labelTitle = new JLabel();
    private JButton backButton = null;
    private boolean wasCancelled = false;

    public Wizard(Frame owner, Object userObject, WizardStep[] steps) {
        super(owner);
        this.steps = steps;
        this.associateSteps();
        this.userObject = userObject;
        this.initialize();
        this.setModal(true);
        this.centerOnOwner();
    }

    public Wizard(Frame owner, Object userObject, WizardStep[] steps, int width, int height) {
        super(owner);
        this.steps = steps;
        this.associateSteps();
        this.userObject = userObject;
        this.initialWidth = width;
        this.initialHeight = height;
        this.initialize();
        this.setModal(true);
        this.centerOnOwner();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setText("Back");
            this.backButton.setEnabled(false);
            this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/images/atras.png")));
            this.backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.assistantLayout.previous(Wizard.this.getStepContentPanel());
                    Wizard.this.currentStep--;
                    if (Wizard.this.currentStep < Wizard.this.steps.length - 1) {
                        Wizard.this.getNextButton().setText("Next");
                    }
                    Wizard.this.steps[Wizard.this.currentStep].onEnter();
                    Wizard.this.labelTitle.setIcon(Wizard.this.steps[Wizard.this.currentStep].getHeaderIcon());
                    if (Wizard.this.currentStep == 0) {
                        Wizard.this.backButton.setEnabled(false);
                    }
                    if (Wizard.this.steps.length > 0) {
                        Wizard.this.nextButton.setEnabled(true);
                    }
                }
            });
        }
        return this.backButton;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(flowLayout1);
            flowLayout1.setAlignment(2);
            this.buttonsPanel.add((Component)this.getBackButton(), null);
            this.buttonsPanel.add((Component)this.getNextButton(), null);
            this.buttonsPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonsPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/images/cancel.png")));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.wasCancelled = true;
                    Wizard.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.labelTitle.setOpaque(true);
            this.labelTitle.setBackground(Color.WHITE);
            this.labelTitle.setIcon(this.steps[this.currentStep].getHeaderIcon());
            this.jContentPane.add((Component)this.labelTitle, "North");
            this.jContentPane.add((Component)this.getButtonsPanel(), "South");
            this.jContentPane.add((Component)this.getStepContentPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setText("Next");
            if (this.currentStep == this.steps.length - 1) {
                this.nextButton.setText("Finish");
            }
            if (this.steps.length == 0) {
                this.nextButton.setEnabled(false);
            }
            this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/images/adelante.png")));
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Wizard.this.steps[Wizard.this.currentStep].onNext()) {
                        Wizard.this.assistantLayout.next(Wizard.this.getStepContentPanel());
                        if (Wizard.this.currentStep == Wizard.this.steps.length - 1) {
                            Wizard.this.setVisible(false);
                            return;
                        }
                        Wizard.this.currentStep++;
                        Wizard.this.steps[Wizard.this.currentStep].onEnter();
                        Wizard.this.labelTitle.setIcon(Wizard.this.steps[Wizard.this.currentStep].getHeaderIcon());
                        Wizard.this.backButton.setEnabled(true);
                    }
                    if (Wizard.this.currentStep == Wizard.this.steps.length - 1) {
                        Wizard.this.nextButton.setText("Finish");
                    }
                }
            });
        }
        return this.nextButton;
    }

    private JPanel getStepContentPanel() {
        if (this.stepContentPanel == null) {
            this.stepContentPanel = new JPanel();
            this.stepContentPanel.setOpaque(true);
            this.stepContentPanel.setBackground(Color.WHITE);
            this.assistantLayout = new CardLayout();
            this.stepContentPanel.setLayout(this.assistantLayout);
            for (int i = 0; i < this.steps.length; ++i) {
                this.stepContentPanel.add((Component)this.steps[i].getContentComponent(), "Step-" + i);
            }
            if (this.steps.length > 0) {
                this.steps[0].onEnter();
            }
            this.stepContentPanel.setBackground(Color.white);
            this.stepContentPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        return this.stepContentPanel;
    }

    private void associateSteps() {
        for (int i = 0; i < this.steps.length; ++i) {
            this.steps[i].setWizard(this);
        }
    }

    private void centerOnOwner() {
        Rectangle rectOwner = this.getParent().getBounds();
        Rectangle rectDialog = this.getBounds();
        this.setLocation(rectOwner.x + rectOwner.width / 2 - rectDialog.width / 2, rectOwner.y + rectOwner.height / 2 - rectDialog.height / 2);
    }

    private void initialize() {
        this.setResizable(false);
        this.setSize(this.initialWidth, this.initialHeight);
        if (this.steps == null) {
            return;
        }
        this.setContentPane(this.getJContentPane());
        this.pack();
    }
}

