/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.utilities;

import es.uvigo.ei.aibench.workbench.OperationWrapper;
import es.uvigo.ei.aibench.workbench.Workbench;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;

public class Utilities {
    private static int MAX_MENUITEMS = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 25;

    public static Frame getParentFrame(Component component) {
        Container parent;
        if (component == null) {
            return null;
        }
        for (parent = component.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return (Frame)parent;
    }

    public static void centerOnWindow(Component component) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle pantalla = ge.getMaximumWindowBounds();
        Dimension componentDimension = component.getPreferredSize();
        int x = (pantalla.width - (int)componentDimension.getWidth()) / 2;
        int y = (pantalla.height - (int)componentDimension.getHeight()) / 2;
        component.setLocation(x, y);
    }

    public static void centerOnOwner(Component component) {
        Rectangle rectOwner = component.getParent().getBounds();
        Rectangle rectDialog = component.getBounds();
        component.setLocation(rectOwner.x + rectOwner.width / 2 - rectDialog.width / 2, rectOwner.y + rectOwner.height / 2 - rectDialog.height / 2);
    }

    public static File getFile(FileFilter filter) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void putOperationInMenu(MenuElement root, OperationWrapper opw) {
        String path = opw.getOperationDefinition().getPath();
        if (path == null || path.equals("")) {
            return;
        }
        Object[] res = Utilities.getOperationMenu(root, path);
        Utilities.constructMenu((JComponent)res[0], (String)res[1], opw);
    }

    private static Object[] getOperationMenu(MenuElement currentMenu, String path) {
        int i;
        int count;
        JComponent bar;
        if (path == null || path.equals("")) {
            return new Object[]{currentMenu, path};
        }
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        if (currentMenu instanceof JMenuBar) {
            bar = (JMenuBar)currentMenu;
            count = ((JMenuBar)bar).getMenuCount();
            for (i = 0; i < count; ++i) {
                menus.add(((JMenuBar)bar).getMenu(i));
            }
        } else if (currentMenu instanceof JPopupMenu) {
            bar = (JPopupMenu)currentMenu;
            count = ((JPopupMenu)bar).getSubElements().length;
            for (i = 0; i < count; ++i) {
                if (!((JMenu)((JPopupMenu)bar).getSubElements()[i] instanceof JMenu)) continue;
                menus.add((JMenu)((JPopupMenu)bar).getSubElements()[i]);
            }
        } else {
            JMenu menu = (JMenu)currentMenu;
            count = menu.getMenuComponentCount();
            for (i = 0; i < count; ++i) {
                Component comp = menu.getMenuComponent(i);
                if (!(comp instanceof JMenu)) continue;
                menus.add((JMenu)comp);
            }
        }
        StringTokenizer tk = new StringTokenizer(path, "/");
        String pathElement = null;
        if (tk.hasMoreTokens()) {
            pathElement = tk.nextToken();
            for (i = 0; i < menus.size(); ++i) {
                String noAt = pathElement;
                if (pathElement.indexOf("@") != -1) {
                    noAt = pathElement.substring(pathElement.indexOf("@") + 1);
                }
                if (((JMenu)menus.get(i)).getText() == null || !((JMenu)menus.get(i)).getText().equals(noAt)) continue;
                if (tk.hasMoreTokens()) {
                    return Utilities.getOperationMenu((MenuElement)menus.get(i), path.substring(pathElement.length() + 1));
                }
                return Utilities.getOperationMenu((MenuElement)menus.get(i), "");
            }
        }
        return new Object[]{currentMenu, path};
    }

    private static void constructMenu(JComponent root, String path, OperationWrapper opw) {
        GridLayout menuGrid;
        JMenu rootMenu;
        StringTokenizer tk = new StringTokenizer(path, "/");
        String pathElement = null;
        while (tk.hasMoreTokens()) {
            String noAt = pathElement = tk.nextToken();
            if (pathElement.indexOf("@") != -1) {
                noAt = pathElement.substring(pathElement.indexOf("@") + 1);
            }
            JMenu child = new JMenu(noAt);
            if (root instanceof JMenuBar) {
                ((JMenuBar)root).add(child);
            } else if (root instanceof JPopupMenu) {
                ((JPopupMenu)root).add(child);
            } else {
                rootMenu = (JMenu)root;
                rootMenu.insert(child, ((JMenu)root).getItemCount());
                if (rootMenu.getItemCount() > MAX_MENUITEMS) {
                    menuGrid = new GridLayout(rootMenu.getItemCount() / (rootMenu.getItemCount() / MAX_MENUITEMS + 1) + 1, rootMenu.getItemCount() / (MAX_MENUITEMS + 1));
                    rootMenu.getPopupMenu().setLayout(menuGrid);
                }
            }
            root = child;
        }
        JMenuItem item = new JMenuItem(opw);
        ImageIcon icon = Workbench.getInstance().getOperationIcon(opw.getOperationDefinition());
        if (icon != null) {
            item.setIcon(icon);
        }
        root.add(item);
        if (!(root instanceof JMenuBar) && (rootMenu = (JMenu)root).getItemCount() > MAX_MENUITEMS) {
            menuGrid = new GridLayout(rootMenu.getItemCount() / (rootMenu.getItemCount() / MAX_MENUITEMS + 1) + 1, rootMenu.getItemCount() / (MAX_MENUITEMS + 1));
            rootMenu.getPopupMenu().setLayout(menuGrid);
        }
    }
}

