/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.tree;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.CoreUtils;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.datatypes.Transformer;
import es.uvigo.ei.aibench.core.datatypes.annotation.Datatype;
import es.uvigo.ei.aibench.core.datatypes.annotation.ListElements;
import es.uvigo.ei.aibench.core.datatypes.annotation.Structure;
import es.uvigo.ei.aibench.core.history.HistoryElement;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.OperationWrapper;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.ParamsWindow;
import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AIBenchTreeMouseListener
extends MouseAdapter {
    @Override
    public void mouseClicked(MouseEvent e) {
        Component comp;
        if (e.getClickCount() == 1 && !e.isPopupTrigger() && (comp = e.getComponent()) instanceof JTree) {
            DefaultMutableTreeNode node;
            JTree tree = (JTree)comp;
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            tree.setSelectionPath(selPath);
            if (selPath != null && selPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof ClipboardItem) {
                Workbench.getInstance().showData((ClipboardItem)node.getUserObject());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.doMouseAction(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doMouseAction(e);
    }

    private void doMouseAction(MouseEvent e) {
        Component comp;
        if (e.isPopupTrigger() && (comp = e.getComponent()) instanceof JTree) {
            JTree tree = (JTree)comp;
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            tree.setSelectionPath(selPath);
            if (selPath != null && selPath.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                final DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.getUserObject() instanceof ClipboardItem) {
                    ClipboardItem item;
                    ParamsWindow.preferredClipboardItem = item = (ClipboardItem)node.getUserObject();
                    Object data = item.getUserData();
                    JPopupMenu popup = this.getApplicableOperationsPopup(data);
                    popup.addSeparator();
                    Datatype datatypeAnnot = data.getClass().getAnnotation(Datatype.class);
                    if (datatypeAnnot != null) {
                        if (datatypeAnnot.removable()) {
                            if (datatypeAnnot.removeMethod().equalsIgnoreCase("")) {
                                DefaultMutableTreeNode parent;
                                if (datatypeAnnot.structure() == Structure.LIST && (parent = (DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof ClipboardItem) {
                                    ClipboardItem itemcontainer = (ClipboardItem)parent.getUserObject();
                                    for (Method m : itemcontainer.getUserData().getClass().getMethods()) {
                                        ListElements le = m.getAnnotation(ListElements.class);
                                        if (le == null || !le.modifiable()) continue;
                                        try {
                                            Object containerlist = m.invoke(itemcontainer.getUserData(), new Object[0]);
                                            if (!(containerlist instanceof List)) continue;
                                            this.addListRemove(popup, item, itemcontainer, (List)containerlist);
                                        }
                                        catch (IllegalArgumentException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (IllegalAccessException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (InvocationTargetException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                                this.addRemove(popup, item);
                            } else {
                                try {
                                    Method m = item.getUserData().getClass().getMethod(datatypeAnnot.removeMethod(), new Class[0]);
                                    this.addSpecificRemove(popup, item, m);
                                }
                                catch (SecurityException e1) {
                                    e1.printStackTrace();
                                }
                                catch (NoSuchMethodException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (datatypeAnnot.renameable() && datatypeAnnot.setNameMethod().equalsIgnoreCase("")) {
                            this.addRename(popup, item);
                        }
                    } else {
                        this.addRemove(popup, item);
                        this.addRename(popup, item);
                    }
                    if (datatypeAnnot != null) {
                        this.addHelp(popup, datatypeAnnot);
                    }
                    if (popup.getSubElements().length > 0) {
                        popup.show(comp, e.getX(), e.getY());
                    }
                } else if (node.getUserObject() instanceof HistoryElement) {
                    JPopupMenu popup = new JPopupMenu();
                    AbstractAction action = new AbstractAction(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getInstance().getHistory().removeItem((HistoryElement)node.getUserObject());
                        }
                    };
                    action.putValue("Name", "remove element...");
                    popup.add(action);
                    popup.show(comp, e.getX(), e.getY());
                }
            } else {
                JPopupMenu popup = this.getOperationsWithAnyClipboardPopup();
                popup.show(comp, e.getX(), e.getY());
            }
        }
    }

    private void addRename(JPopupMenu pop, final ClipboardItem item) {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog(Workbench.getInstance().getMainFrame(), "New name: ", item.getName());
                if (newName != null) {
                    item.setName(newName);
                    Datatype datatypeAnnot = item.getUserData().getClass().getAnnotation(Datatype.class);
                    if (datatypeAnnot != null && datatypeAnnot.renameable() && !datatypeAnnot.setNameMethod().equals("")) {
                        try {
                            Method m = item.getUserData().getClass().getMethod(datatypeAnnot.setNameMethod(), String.class);
                            m.invoke(item.getUserData(), newName);
                        }
                        catch (SecurityException f) {
                            f.printStackTrace();
                        }
                        catch (NoSuchMethodException f) {
                            f.printStackTrace();
                        }
                        catch (IllegalArgumentException f) {
                            f.printStackTrace();
                        }
                        catch (IllegalAccessException f) {
                            f.printStackTrace();
                        }
                        catch (InvocationTargetException f) {
                            f.printStackTrace();
                        }
                    }
                    JTree clipboardTree = Workbench.getInstance().getTreeManager().getAIBenchClipboardTree();
                    DefaultMutableTreeNode _node = Workbench.getInstance().getTreeManager().findNodeForUserObject(item, clipboardTree);
                    ((DefaultTreeModel)clipboardTree.getModel()).nodeChanged(_node);
                    JTree sessionTree = Workbench.getInstance().getTreeManager().getAIBenchTree();
                    _node = Workbench.getInstance().getTreeManager().findNodeForUserObject(item, sessionTree);
                    ((DefaultTreeModel)sessionTree.getModel()).nodeChanged(_node);
                }
            }
        };
        action.putValue("Name", "rename element...");
        pop.add(action);
    }

    private void addRemove(JPopupMenu pop, final ClipboardItem item) {
        if (Core.getInstance().getClipboard().getRootItems().indexOf(item) != -1) {
            AbstractAction action = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getInstance().getClipboard().removeClipboardItem(item);
                }
            };
            action.putValue("Name", "remove element...");
            pop.add(action);
        }
    }

    private void addHelp(JPopupMenu popup, final Datatype itemDatatype) {
        if (itemDatatype.help() != null && !itemDatatype.help().trim().equals("")) {
            if (CoreUtils.isValidURL((String)itemDatatype.help())) {
                popup.add(new AbstractAction("what's this?"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            CoreUtils.openURL((String)itemDatatype.help());
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(Workbench.getInstance().getMainFrame(), "The help URL(" + itemDatatype.help() + ") couldn't be opened.", "Help Unavailable", 0);
                        }
                    }
                });
            } else {
                HelpBroker broker = Core.getInstance().getHelpBroker();
                if (broker != null) {
                    JMenuItem helpItem = new JMenuItem("what's this?");
                    broker.enableHelpOnButton((Component)helpItem, itemDatatype.help(), broker.getHelpSet());
                    popup.add(helpItem);
                }
            }
        }
    }

    private void addListRemove(JPopupMenu pop, final ClipboardItem item, ClipboardItem parentItem, final List<?> containerlist) {
        if (Core.getInstance().getClipboard().getListSubItems(parentItem).indexOf(item) != -1) {
            AbstractAction action = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("========LIST REMOVE ACTIVATED!!!!!!!!!!!!!!!==============");
                    Object data = item.getUserData();
                    Core.getInstance().getClipboard().removeClipboardItem(item);
                    containerlist.remove(data);
                }
            };
            action.putValue("Name", "remove element...");
            pop.add(action);
        }
    }

    private void addSpecificRemove(JPopupMenu pop, final ClipboardItem item, final Method m) {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("========SPECIFIC REMOVE ACTIVATED!!!!!!!!!!!!!!!==============");
                try {
                    m.invoke(item.getUserData(), new Object[0]);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
                Core.getInstance().getClipboard().removeClipboardItem(item);
            }
        };
        action.putValue("Name", "remove element...");
        pop.add(action);
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz.isPrimitive() || clazz.getEnumConstants() != null || File.class.isAssignableFrom(clazz);
        }
        return this.isPrimitive(clazz.getComponentType());
    }

    private JPopupMenu getOperationsWithAnyClipboardPopup() {
        JPopupMenu popup = new JPopupMenu();
        for (OperationWrapper wrapper : Workbench.getInstance().getInterceptedOperations()) {
            boolean hasClipboardInput = false;
            int counter = 0;
            for (Object incomingType : wrapper.getOperationDefinition().getIncomingArgumentTypes()) {
                Class clazz = (Class)incomingType;
                if (this.isPrimitive(clazz) || ((Port)wrapper.getOperationDefinition().getPorts().get(counter++)).allowNull()) continue;
                try {
                    clazz.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    hasClipboardInput = true;
                }
            }
            if (hasClipboardInput || !Workbench.getInstance().isOperationViewableIn(wrapper.getOperationDefinition(), "POPUP")) continue;
            Utilities.putOperationInMenu(popup, wrapper);
        }
        return popup;
    }

    private JPopupMenu getApplicableOperationsPopup(Object data) {
        HashMap<OperationWrapper, Integer> added = new HashMap<OperationWrapper, Integer>();
        JPopupMenu popup = new JPopupMenu();
        for (OperationWrapper wrapper : Workbench.getInstance().getInterceptedOperations()) {
            for (Object incomingType : wrapper.getOperationDefinition().getIncomingArgumentTypes()) {
                Class clazz = (Class)incomingType;
                if (clazz.isAssignableFrom(data.getClass())) {
                    if (added.get(wrapper) != null) continue;
                    added.put(wrapper, 0);
                    if (Workbench.getInstance().isOperationViewableIn(wrapper.getOperationDefinition(), "POPUP")) {
                        Utilities.putOperationInMenu(popup, wrapper);
                    }
                }
                List transformers = Core.getInstance().getTransformersByDestiny(clazz);
                for (Transformer t : transformers) {
                    if (!t.getSourceType().isAssignableFrom(data.getClass()) || !Workbench.getInstance().isOperationViewableIn(wrapper.getOperationDefinition(), "POPUP") || added.get(wrapper) != null) continue;
                    added.put(wrapper, 0);
                    Utilities.putOperationInMenu(popup, wrapper);
                }
            }
        }
        return popup;
    }
}

